/* define THRESH 20 */

#include <stdio.h>
#include <ctype.h>

#define SIZE 10000

main(argc, argv)
int argc;
char **argv;
{
	register char *cp, *ocp;
	char line[SIZE];
	char outline[SIZE*2];
	int length = SIZE;

#define C(x) ((x)&255)
#define isvowel(x) ((x)=='A' || (x)=='E' || (x)=='I' || (x)=='O' || (x)=='U')
#define is_aiu(x) ((x)=='A' || (x)=='I' || (x)=='U')

#define T1(x1, y) \
	else if (C(cp[0]) == (x1) ) { \
		ocp += sprintf(ocp, y); \
		cp += 1; \
	}
#define T2(x1, x2, y) \
	else if (C(cp[0]) == (x1) && C(cp[1]) == (x2)) { \
		ocp += sprintf(ocp, y); \
		cp += 2; \
	}

#define T2N(x1, x2, Test, y) \
	else if (C(cp[0]) == (x1) && C(cp[1]) == (x2) && (Test)) { \
		ocp += sprintf(ocp, y); \
		cp += 2; \
	}

#define T3(x1, x2, x3, y) \
	else if (C(cp[0]) == (x1) && C(cp[1]) == (x2) && C(cp[2]) == (x3)) { \
		ocp += sprintf(ocp, y); \
		cp += 3; \
	}

while(gets(line)) {
	length = strlen(line);
	for(cp = line, ocp = outline; *cp; ) {
		if (cp - line > length) break;
		T2(0xE7, 'N',		"NG")
		T2(0xE2, 'N',		"NG")
		T2(0xE2, 'I',		"'I")
		T2(0xE2, 'U',		"'U")

		T3(0xF2, 'T', 'H',	"th")
		T2(0xF2, 'T',		"t")

		T3(0xF2, 'D', 'H',	"dh")
		T2(0xF2, 'D',		"d")

		T2(0xF2, 'N',		"n")
		T2(0xF2, 'H',		"{f2H=:}")
		T3('T',  'S', 'H',	"TS")

		else if(cp[0]=='T' && cp[1]=='S' && cp[2] != ' ') {
			ocp += sprintf(ocp, "TZ");
			cp += 2;
		}

		T2(0xE2, 'Z',		"ZH")
		T3('G',  0xAE, 'Y',	"GA-Y")
		T3('G',  0xA7, 'Y',	"GA-Y")
		T3('G',  0xE2, 'Y',	"GA-Y")

		T1(0xAE, 			"'")
		T1(0xA7, 			"'")

		T2(0xE2, 'S',		"SH")
		T2(0xF2, 'S',		"sh")

		else if(isvowel(cp[0]) && C(cp[1])==0xAE && isvowel(cp[2]) ) {
			*ocp++ = cp[0];
			*ocp++ = '\'';
			*ocp++ = cp[2];
			cp += 3;
		}
		else if(cp[0]==' ' && C(cp[1])==0xE5 && is_aiu(cp[2]) ) {
			*ocp++ = cp[2];
			*ocp++ = '\'';
			*ocp++ = cp[2];
			cp += 3;
		}
		else if(C(cp[0])==0xE5 && is_aiu(cp[1]) ) {
			*ocp++ = '\'';
			*ocp++ = cp[1];
			cp += 2;
		}
		T2(0xE4, 'N',		"NY")
		T3(0xF2,  0xE5, 'R',	"R'i")
		T3(0xE5,  0xF2, 'R',	"R'i")
		T2(0xF2,  		'R',	"Ri")

		T3(0xF2,  0xE5, 'L',	"L'i")
		T3(0xE5,  0xF2, 'L',	"L'i")
		T2(0xF2,  		'L',	"Li")
		T2(0xF2,  		'M',	"m")
		T2(0xE7,  		'M',	"m")

	T1(0xE5, 					"{e5='}")
	/* French accent grave: */
	T2(0xE2,  		'E',	"E")
	/* German, Chinese umlaut: */
	T1(0xE8,  		"")

	T1(0xFF,  		"")
	T1(0xFE,  		"")

		else if (! isascii(*cp)) {
			ocp += sprintf(ocp, "{%x}", C(*cp));
			if (cp > line && isascii(*(cp-1)) && isupper(*(cp-1)) )
				fprintf(stderr, "%c", *(cp-1));
			fprintf(stderr, "{%x}", C(*cp));
			if (isascii(*(cp+1)) && isupper(*(cp+1)) )
				fprintf(stderr, "%c", *(cp+1));
			fputc('\n', stderr);
			cp++;
		}
		else  {
			*ocp++ = *cp++;
		}
	}
	*ocp = '\0';
	printf("%s\n", outline);
}
fprintf(stderr, "DONE.\n");
}
		/* T2(0xE1, 'N', "NG++") */
