/*** include files: ***/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <direct.h>

#include <ctype.h>
#include "config.h"

#define LZ 384
/* forward */
int doDir(char *pattern, char *rbuf);

/* from 8, fill buf with "4A": */
 void
prPageN(long L, char *buf)
{
	char *cp = buf;
	cp += sprintf(cp, "%ld", L/2);
	if (L%2 == 1) *cp = 'B';
	else *cp = 'A';
	cp++;
	*cp = 0; 
}
/* from "4A" return 8: */
 long
convertPageN(unsigned char *lp)
{
	long P = atol(lp) * 2;
	while(isdigit(*lp)) lp++;
	if (*lp == 'B') P += 1;
	return(P);
}

typedef struct PageInfo {
	int LC; /* linecount */
	int CC;
	int P;
#define ccaZ 10
	int cca[ccaZ]; /* usually 7 */
	int ccz;
} PageInfo;
typedef struct DocInfo {
	long ePageSequence, ePageLC, eExtra, eCChigh, eCClow;
	long gLC;
	int pLC_ref;
	long gCC;
	int tbCC_ref;
	int RefPageN, ORefPageN;
	double tolerance;
} DocInfo;
/*
1A	2
1B	3
2A	4
2B	5
3A	6
3B	7
4A	8
4B	9
*/
DocInfo D;
 void
checkCC(int tbCC, char *page, int lineN)
{
	double dr;
	dr = (tbCC*1.0) / D.tbCC_ref;
	if (dr > (1.0+D.tolerance)) {
		D.eCChigh++;
		printf("!Page %s:   line %d too long:  %6.1f percent\n",
			page, lineN, dr*100.0);
	}
	else if (dr < (1.0-D.tolerance) )
	{
		D.eCClow++;
		printf("!Page %s:   line %d too short: %6.1f percent\n",
			page, lineN, dr*100.0);
	}
}
 int
main(int argc, char ** argv)
{
	char Line[LZ], word[256], lbuf[384];
	FILE *fp;
	char *dirname;
	char filename[256];
	char fullPath[384];
	unsigned char *lp;
	char *cp;
	Config *cfp;

	int exi;
	char exA[LZ];
	int pLC, tbCC, empty, z, cci;
	long P, firstP, lastP, newP, tPages;
#define piaZ 30
	PageInfo pia[piaZ]; /* 8 == 4A */
/* an array of the char counts of Tibetan lines within a Tibetan page */

	D.tolerance = 0.25;
	D.ORefPageN = 8; /* 4A */

	if (cfp = newConfig("eval.cfg")) {
		if (cp = getValue(cfp, "RefPage")) {
			D.ORefPageN = convertPageN(cp);
		}
		if (cp = getValue(cfp, "Tolerance")) {
			D.tolerance = atof(cp) / 100.0;
			if (D.tolerance < 0.01) D.tolerance = 0.01;
			else if (D.tolerance > 0.95) D.tolerance = 0.95;
		}
	}

	if (argc < 2) {
printf("USAGE:  eval [-rRefPage] [-tTolerance] FileSpec\n");
printf("for example:  eval -r5A -t35 c:\\Stuff\\e*.*\n");
		return(1);
	}
	for (z = 1; z < argc; z++) {
		if (*(cp = argv[z]) == '-') {
			switch (*(cp + 1)) {
			case 'r':
				D.ORefPageN = convertPageN(cp + 2);
				break;
			case 't':
				D.tolerance = atof(cp + 2) / 100.0;
				break;
			}
		}
		else {
			dirname = argv[z];
			break;
		}
	}

	if (D.ORefPageN < 2) D.ORefPageN = 2;
// talk it up:
	prPageN(D.ORefPageN, word);
	printf("using: RefPage %s, Tolerance %0.1f percent\n",
		word, D.tolerance*100.0);

// is it a full path?
	if (strchr(dirname, ':') || strchr(dirname, '\\')) {
		strcpy(fullPath, dirname);
	}
	else { // relative
		getcwd(fullPath, 256);
		strcat(fullPath, "\\");
		strcat(fullPath, dirname);
		if (!strchr(dirname, '.'))
			strcat(fullPath, "\\");
		//_getdcwd(drive, fullPath, 128);
//printf("relative: {%s}\n", fullPath);
	}
		cp = fullPath + strlen(fullPath);
		while (cp > fullPath && *cp != '\\') cp--;
		*cp = 0;
//printf("final: {%s}\n", fullPath);

// for each file
while( doDir(dirname, filename) ) {
	D.RefPageN = D.ORefPageN;
	D.ePageSequence = D.ePageLC =  D.eExtra = D.eCChigh = D.eCClow = 0;
	D.pLC_ref = D.gLC = 0;
	D.tbCC_ref = D.gCC = 0;
	pLC = 0;
	tbCC = 0;
	lastP = 1;
	P = 0;
	tPages = 0;
	cci = 0;
	firstP = -1;

	sprintf(lbuf, "%s\\%s", fullPath, filename);
	if (!(fp = fopen(lbuf, "r"))) {
		printf("'%s': no such file\n", lbuf);
		continue;
	}

	for(z = 0; z < piaZ; z++) pia[lastP].LC = 0;

	printf("\n--------- Begin  %s\\ %s\n",fullPath,filename);
while(fgets(Line, LZ, fp)) {
	z = strlen(Line) - 1;
	Line[z] = 0;
	/* no space at front or back: */
	while(z > 0 && Line[z] == ' ') z--;
	if (z > 0) z++;
	Line[z] = 0;
	for(lp = Line; *lp == ' '; lp++);

	D.gCC += z;
	empty = 0;
	if (!*lp) { /* double return: end of a Tibetan line */
		D.gLC++;
		pLC++;

//printf("end of Tib line; pLC %d; tPages %d<%d; cci %d<%d\n",
//pLC, tPages, piaZ, cci, ccaZ);

		empty = 1;
		if (D.tbCC_ref) {
			prPageN(P, word);
			checkCC(tbCC, word, cci+1);
		}
		/* store char count for this Tibetan line */
		if (tPages < piaZ && cci < ccaZ) {
			pia[tPages].cca[cci] = tbCC;
			pia[tPages].ccz = cci;
		}
		cci++; // number of tibetan lines / page
		tbCC = 0;
	}
	else {
		tbCC += z; /* + char count for this Tibetan line */
	}
	if (*lp == '@') { /* new Tibetan page */
		newP = convertPageN(++lp);
		if (firstP < 0) firstP = newP;

//prPageN(newP, word); printf("got newP {%s}\n", word);

		if (tPages < piaZ) {
			pia[tPages].LC = pLC;
		}

// newP == 5B, lastP == 5A, RefPageN == 5A
		if (!D.pLC_ref && pLC && lastP >= D.RefPageN) { /* 8 == 4A */
			int i, j, tc;
			/* now we have ref page; check previous pages: */
			D.pLC_ref = pLC;

//printf("  at ref page cci = %d; tPages %d\n", cci, tPages);
			/* get mean char count: */
			tc = 0;
			//if ((i = tPages-1) < 0) i = 0;
			i = tPages;
			if (i >= piaZ) i = piaZ - 1;
			for (j = 1; j < cci; j++) {

//printf(" tc += pia[%d].cca[%d]  %d\n", i, j, pia[i].cca[j]);

				tc += pia[i].cca[j];
			}
//printf("tc = %d, cci = %d\n", tc, cci);
			if ((j = cci-1) <= 0)
				D.tbCC_ref =  1;
			else
				D.tbCC_ref =  tc / (j);

 prPageN(lastP, word);
 printf("using line count = %d; chars/line %d  from RefPage %s\n",
  D.pLC_ref, D.tbCC_ref, word);

			if (firstP == 2) // 1A 
				i = 4; // 2A ; allow for special 1st pages
			else
				i = 0; // do not allow
			for(; i < tPages && i < piaZ; i++) {
/* never processed for some reason: */
				if (pia[i].LC == 0) continue;
				if (pia[i].LC != D.pLC_ref) {
				 D.ePageLC++;
				 prPageN(pia[i].P, word);
				 printf("!Page %s: line count: %d\n",
					word, pia[i].LC);
				}

				prPageN((long)i, word);
				for (j = 1; j < pia[i].ccz; j++) {
					checkCC(pia[i].cca[j],
					 word, j+1);
				}
			}
		}
		if (lastP > D.RefPageN) {
			if (pLC != D.pLC_ref) {
				D.ePageLC++;
				prPageN(P, word);
				printf("!Page %s: line count: %d\n",
					word, pLC, D.pLC_ref);
			}
		}

//printf("{%3.3s} page P = %ld   lastP = %ld\n", lp, P, lastP);

		P = newP;
		if (P != lastP + 1) {
			if (lastP == 1) { // first page
				//if (D.RefPageN <= P)
				if (D.RefPageN < P)
				{
 prPageN(P, lbuf);
 printf("!!! document starts at %s;\n", lbuf);
 prPageN(D.RefPageN, lbuf);
					D.RefPageN = newP+4;
 prPageN(D.RefPageN, word);
 printf("reset RefPage from %s to %s\n", lbuf, word);
				}
			}
			else {
			 D.ePageSequence++;
			 prPageN(P, word);
			 prPageN(lastP, lbuf);
			 printf("!Page %s  Out of Sequence; comes after  %s\n",
					word, lbuf);
			}
		}
		lastP = P;
		pLC = 0;
		cci = 0;
		tPages++;
		if (tPages < piaZ) pia[tPages].P = P;
	}

// extra ascii data?
		exi = 0;
		for(; *lp && exi < 5; lp++) {
			if (*lp > 126 ||
			(*lp < 32 && *lp != 10 && *lp != 13 && *lp != 9))
			{
				exA[exi++] = *lp;
			}
		}
		if (exi > 0) {
			D.eExtra++;
			prPageN(P, word);
			printf("!Page %s, line %d: invalid characters: ",
				word, cci+1);
			for(z = 0; z < exi; z++) {
				printf("0x%x ", exA[z]);
			}
			printf("\n");
		}

}
	fclose(fp);

	printf("--------- Totals for  %s\\ %s -----------\n",fullPath,filename);
	printf("%5ld  total Tibetan lines\n", D.gLC);
	prPageN(P, word);
	printf("%5ld  total pages ending with %s\n", tPages, word);

	prPageN(D.RefPageN, word);
if (!D.pLC_ref) {
	printf("!!! RefPage %s never found! Test invalid!!!\n",
		word);
}
else {
	//printf("%ld  total characters; ", D.gCC);
	printf("%5d  chars/line on RefPage  %s\n",
		D.tbCC_ref, word);
	if (D.ePageLC)
		printf("  %4ld  page(s) had incorrect line counts\n",
		D.ePageLC);
	if (D.eCChigh)
		printf("  %4ld  line(s)   too long\n", D.eCChigh);
	if (D.eCClow)
		printf("  %4ld  line(s)   too short\n", D.eCClow);
}
	if (D.eExtra)
		printf("  %4ld  line(s) had invalid ascii characters\n",
		D.eExtra);
	if (D.ePageSequence)
		printf("  %4ld  page(s) Out of Sequence\n", D.ePageSequence);

}
	return(0);
}




static char TmpFile[] = "t.out";
FILE *dfp = 0;
 int
doDir(char *pattern, char *rbuf)
{
	int rv;

if (!dfp) {
	char dbuf[128];
	remove(TmpFile);
	sprintf(dbuf, "dir /b %s > %s", pattern, TmpFile);
	if ((rv = system(dbuf)) < 0) {
		printf("cannot exec '%s' == %d\n", dbuf, rv);
		return(0);
	}
	if (!(dfp = fopen(TmpFile, "r"))) {
		printf("cannot open '%s'\n", TmpFile);
		return(0);
	}
}
if (dfp) {
	if (fgets(rbuf, 128, dfp)) {
		rbuf[strlen(rbuf)-1] = 0;
		return 1;
	}
	else {
		fclose(dfp);
	}
}
	return 0; // no more files
}
