/* count11.c - a program to count certain statistics about Tibetan
      text providing it is contained in a properly formatted E-edit
      level format according to ACIP specifications.                  */
/*
	   Programmer: Robert J. Taylor
	        Phone: (301)948-5569
	     Compiler: TurboC, Version 1.5
	Date Compiled: March 25, 1990
	      Version: 1.1
*/

/* #define TEST      */
#include <stdio.h>
#include <ctype.h>
#include <dir.h>

main (argc, argv)
char *argv[];
int argc;
{
	FILE  *fopen(), *fp_in, *printer;
	int c, c1 = ' ', c2 = ' ', c3 = ' ', linecnt = 1, slashcnt = 0;
	int tsekcnt = 0, tsektot = 0, syllcnt = 0, numcnt = 0, totsyllcnt = 0;
	int totlinecnt = 1, exit();
    long countch = 0, totalch = 0;
	static char path[MAXPATH], drive[MAXDRIVE], dir[MAXDIR];
	static char name[MAXFILE], ext[MAXEXT];
	enum boolean {FALSE, TRUE} print = FALSE;
	enum swonoff {OFF, ON} pageflag;
	char pagenum[7];
	void syntax_msg();

	#ifdef TEST
		int i;
		printf ("argc: %d\n", argc);
		for (i = 0; i < argc; i++)
			printf ("argv [%d] : %s\n", i, argv[i]);
	#endif
	if (argc != 2)         /* Check for correct number of arguments */
	{
	   fnsplit(argv[0], drive, dir, name, ext);
	   syntax_msg(name);
	   exit(1);
	}

	fp_in = fopen (argv[1],"r");
	if (fp_in == NULL)
	{
        fprintf (stderr, "Input file error: %s\n", argv[1]);
        exit(1);
	}
/*  fp_out = fopen (argv[2], "w");
    if (fp_out == NULL)
    {
        fprintf (stderr, "Output file error: %s\n", argv[2];
        exit(2);
    }
    if ((printer = fopen("prn:", "w")) == NULL)
	{
	   fprintf(stderr, "Unable to open printer.  Screen output only.\n");
       print = FALSE;
	}
    fprintf(print?printer:stdout, "Counts for file \"%s\".\n\n", argv[1]); */
    printf( "          ************************\n"
            "          *     ACIP UTILITY     *\n"
            "          *        COUNT         *\n"
            "          *     Version 1.1      *\n"
            "          *    March 25, 1990    *\n"
            "          ************************\n\n"
            " Statistical counts for the file: \"%s\"\n\n",
            argv[1]);

	while (( c = getc(fp_in)) != EOF )   /* Read characters until     */
	{                                    /*    End-Of-File.           */
        if ( c == '@' )         /* Start of a new page.               */
		{
		    pageflag = ON;   /* During parse of page number.          */
            linecnt = 1;              /* Reset line count.            */
		    continue;
        }
        if ( pageflag == ON)
		{
            if ( c == 'A' || c == 'B' || (c >= '0' && c <= '9' ))
	        {
                pagenum[numcnt++] = c;
	            continue;
			}
            else       /* End of page number string.                  */
	        {
                if ( c != ' ' && c != '*')
			        fprintf (stderr, "Page numbering error on line %d\n", linecnt);
			    pagenum[numcnt] = '\0';     /* Terminate pagenum string. */
                fprintf(print?printer:stdout, "Page number %s:\n", pagenum);
			    numcnt = 0;      /* Reset for beginning of next page. */
			    pageflag = OFF;  /* No longer in page number itself  */
            }
        }
		else
	    {
            if (!( c == '\n' && c1 == '\n' ))   /* If not line end.   */
            {
                if ( c == ' ' )          /* Space between syllables   */
                {
                    tsekcnt++;
                    tsektot++;
#ifdef TEST
    fprintf(stderr, "\t\t\t\t\t%d = tsek count in line, %d = tsek total\n",
                                  tsekcnt,tsektot);
#endif
                    if (c1 != ' ')     /* If blank at end of syllable */
                        syllcnt++;     /*   increment syllable count. */

#ifdef TEST
    fprintf(stderr, "\t\t\t\t\t\t%d = syllable count in line\n"
                    "\t\t\t\t\t\t%d = count of total lines\n",
                                  syllcnt, totlinecnt);
#endif
                }
                else
                    if (c != '\n' && c != ' ')
                        countch++;   /* Otherwise increment character */
            }                        /*    count.                     */
            else                /* End of line */
            {

                syllcnt++;        /* Count last syllable in line      */
			    printf("Line %d - %ld roman characters "
                       "and %d syllables.\n",
						linecnt, countch, syllcnt);
			    totalch += countch;
				totsyllcnt += syllcnt;
                linecnt++;
                totlinecnt++;
			    countch = 0;           /*  Reset for next line.       */
			    syllcnt = 0;           /* Reset for next line.        */
            }
        }
		c3 = c2;
		c2 = c1;
		c1 = c;

    }   /* End of while loop(and file),get next character          */
/*         End of file, make final report.                         */
#ifdef TEST
    fprintf(stderr, "\t\t\t\t%d = total syllable count\n"
                    "\t\t\t\t%d = count of total lines\n"
                    "\t\t\t\t%d = total count of tseks\n",
                                 totsyllcnt, totlinecnt, tsektot);
#endif
                            /* Print statistics for last line.     */
    syllcnt++;
	printf("Line %d - %ld roman characters and %d syllables.\n",
			linecnt, countch, syllcnt);
/*    totlinecnt += linecnt;  */      /* Cumulate page statistics      */
	totalch += countch;          /*     for last line.            */
	totsyllcnt += syllcnt;
                                      /* Print grand total         */
	fprintf(stdout,"\nTotal for the file:\n"
           "\t%ld roman characters and "
			"%d syllables on %d lines.\n",
			 totalch, totsyllcnt, totlinecnt);

	return(0);
}

/* ********************************************************************
*    syntax_msg() - a function to display the correct program usage
*        in case the user entered the program nsme by itself or in
*        case of error.
******************************************************************** */

void syntax_msg(file)
char file[MAXFILE];
{
	fprintf(stderr,"Correct usage is:\n\tC> %s"
	       " <input-file name>"
           "\n\nThis program was designed"
		   " to count the Tibetan lines, characters\nand syllables in "
		   "ACIP Text E-Level files.  \nUse DOS redirect (>) "
           "to create a file containing the output.\n"
           "This is version 1.1, dated 3-25-90\n" ,file);
	exit(0);
}     /*              END OF SYNTAX_MSG()                            */


/* ****************** UPDATE HISTORY ******************************* */
/*
Version 1.1
    -> Changed the character count variables to type "long" to assure
          that they will be correct for numbers > 32K.
    -> Eliminated tsek count because it was perceived as being of no
          value.
    -> Corrected character count that was counting the CR/LF as being
          a character.
    -> Corrected the total character count that was leaving out the
          characters in the last line.
    -> Corrected the total line count that was leaving out the
          last line.
    -> Changed the line count so as to count only the lines on one
          page.  This makes it easier to spot when a line has been
          left out in the original E-file.

*/
