CLEAR , , 400
' $DYNAMIC
TYPE WordRecord
   WORD AS STRING * 10
   NUMBER AS STRING * 20
   filler AS STRING * 2
END TYPE
DIM LONGLIST(6000) AS WordRecord
DIM SHORTLIST$(350, 2)

CLS
PRINT ""
PRINT "        The ACIP to TIBETAN COMPUTER COMPANY (4.10) Format Converter"
PRINT ""
PRINT " This software, written by Tony Duff of the Pema Karpo Translation Committee"
PRINT " at Bauddha, Kathmandu is in the public domain!  The software is distributed"
PRINT " with source code and dictionaries and the conversions done with our original"
PRINT " version are accurate.  Version 1.0 27/3/1995."
PRINT ""
PRINT " Type the name (and path if needed) of the ACIP file to be"
INPUT "  converted and press ENTER: ", I$
PRINT ""
PRINT " Type the name (and path if needed) of the WP 6.0 file"
INPUT "  which will result and press ENTER: ", O$
PRINT ""
PRINT " Reading dictionaries, please wait...";

OPEN I$ FOR INPUT AS #1 LEN = 5120
OPEN O$ FOR OUTPUT AS #2 LEN = 5120

OPEN "HEADER.60" FOR BINARY AS #3
DO UNTIL EOF(3)
   a$ = INPUT$(1, 3)
   PRINT #2, a$;
LOOP
CLOSE (3)

'read common word list, parse entries, and place in array
OPEN "DAT4ACIP" FOR INPUT AS #3
numrec4% = 0
DO UNTIL EOF(3)
   numrec4% = numrec4% + 1
   LINE INPUT #3, a$
   n% = INSTR(1, a$, " ") - 1
'allows for empty entries in dictionary
   IF n% < 0 THEN
   ELSE
      SHORTLIST$(numrec4%, 1) = LEFT$(a$, n%)
      num% = LEN(MID$(a$, n% + 2))
      Numbers$ = RIGHT$(a$, num%)
      FOR n% = 1 TO num% / 4
         x = VAL(MID$(Numbers$, (4 * n%) - 3, 4))
         SHORTLIST$(numrec4%, 2) = SHORTLIST$(numrec4%, 2) + CHR$(240) + CHR$(x MOD 256) + CHR$(INT(x / 256)) + CHR$(240)
      NEXT
   END IF
LOOP
CLOSE (3)

'read long dictionaries, in order into LONGLIST array and get pointers
FOR c% = 1 TO 3
a$ = "DAT" + LTRIM$(STR$(c%)) + "ACIP"
OPEN a$ FOR INPUT AS #3
DO UNTIL EOF(3)
   numrec = numrec + 1
   LINE INPUT #3, a$
   n% = INSTR(1, a$, " ") - 1
'allows for empty entries in dictionary
   IF n% < 0 THEN
   ELSE
      LONGLIST(numrec).WORD = LEFT$(a$, n%)
      num% = LEN(MID$(a$, n% + 2))
      Numbers$ = RIGHT$(a$, num%)
      a$ = ""
      FOR n% = 1 TO num% / 4
         x = VAL(MID$(Numbers$, (4 * n%) - 3, 4))
         a$ = a$ + CHR$(x MOD 256) + CHR$(INT(x / 256))
      NEXT
   END IF
   LONGLIST(numrec).NUMBER = a$
LOOP
CLOSE (3)
numrec(c%) = numrec
NEXT

LOCATE , 2: PRINT "Converting,   0 % done.             ";

'initialize counters
Timetaken = TIMER: bytecounter = 0: bytesinput = 0

'start main conversion.  Loop gets characters one by one until a non-
'alphabetic character is encountered.  If a word part has been obtained
'it is found if possible.  The program looks for it first in the SHORTLIST
'then in the appropriate LONGLIST (in dependence on the first letter of the
'word).  If not found, a second attemtp to find it is made using specialized
'searches.  If still not found, it is  deemed "NOT FOUND".
'
'After the main section for sealing with words, all characters which are not
'Tibetan words are dealt with.  All are dealt with on a one to one basis
'except for CR/LFeeds which need to find and deal with multiple cases of
'CR/LFeeds.

DO UNTIL EOF(1)
   CH$ = INPUT$(1, 1): bytesinput = bytesinput + 1: FIRSTCHAR$ = CH$: x1 = ASC(UCASE$(FIRSTCHAR$)): y = ASC(CH$)
   IF (x1 >= 65 AND x1 <= 90) OR y = 39 OR y = 43 THEN
      CH$ = INPUT$(1, 1): bytesinput = bytesinput + 1: x = ASC(UCASE$(CH$)): y = ASC(CH$)
      IF (x >= 65 AND x <= 90) OR y = 39 OR y = 43 THEN
         WORD$ = FIRSTCHAR$ + CH$
         DO
            CH$ = INPUT$(1, 1): bytesinput = bytesinput + 1: x = ASC(UCASE$(CH$)): y = ASC(CH$)
            IF (x >= 65 AND x <= 90) OR y = 39 OR y = 43 THEN
               WORD$ = WORD$ + CH$
            ELSE
'non-alphabetic character has been encountered therefore a word-part has    
'been discovered.  Now try to find the word-part in the dictionaries.  Start
'with the common word list then try the longer word list.
               FOR c% = 1 TO numrec4%
                  IF WORD$ = SHORTLIST$(c%, 1) THEN
                     FLAGPREVIOUS$ = "WORDFOUND"
                     PRINT #2, SHORTLIST$(c%, 2);
                     GOTO 200
                  END IF
               NEXT
               SELECT CASE x1
                  CASE IS < 68: beginrec% = 1: totalrec% = numrec(1)
                  CASE IS < 80: beginrec% = numrec(1) + 1: totalrec% = numrec(2)
                  CASE ELSE: beginrec% = numrec(2) + 1: totalrec% = numrec(3)
               END SELECT
               FOR c% = beginrec% TO totalrec%
                  IF WORD$ = RTRIM$(LONGLIST(c%).WORD) THEN
                     FLAGPREVIOUS$ = "WORDFOUND"
                     a$ = RTRIM$(LONGLIST(c%).NUMBER)
                     FOR n% = 1 TO LEN(a$) / 2
                        PRINT #2, CHR$(240); MID$(a$, 2 * n% - 1, 2); CHR$(240);
                     NEXT
                     GOTO 200
                  END IF
               NEXT
'Word-part not found by ordinary means so try again by special means
               IF RIGHT$(WORD$, 5) = "A'ANG" OR RIGHT$(WORD$, 5) = "I'ANG" OR RIGHT$(WORD$, 5) = "U'ANG" OR RIGHT$(WORD$, 5) = "E'ANG" OR RIGHT$(WORD$, 5) = "O'ANG" THEN
                  WORD$ = LEFT$(WORD$, LEN(WORD$) - 4)
                  WORDRIGHT$ = CHR$(240) + CHR$(55) + CHR$(12) + CHR$(240) + CHR$(240) + CHR$(36) + CHR$(12) + CHR$(240)
               ELSEIF RIGHT$(WORD$, 4) = "A'AM" OR RIGHT$(WORD$, 4) = "I'AM" OR RIGHT$(WORD$, 4) = "U'AM" OR RIGHT$(WORD$, 4) = "E'AM" OR RIGHT$(WORD$, 4) = "O'AM" THEN
                  WORD$ = LEFT$(WORD$, LEN(WORD$) - 3)
                  WORDRIGHT$ = CHR$(240) + CHR$(55) + CHR$(12) + CHR$(240) + CHR$(240) + CHR$(48) + CHR$(12) + CHR$(240)
               ELSEIF RIGHT$(WORD$, 3) = "A'I" OR RIGHT$(WORD$, 3) = "I'I" OR RIGHT$(WORD$, 3) = "U'I" OR RIGHT$(WORD$, 3) = "E'I" OR RIGHT$(WORD$, 3) = "O'I" THEN
                  WORD$ = LEFT$(WORD$, LEN(WORD$) - 2)
                  WORDRIGHT$ = CHR$(240) + CHR$(55) + CHR$(12) + CHR$(240) + CHR$(240) + CHR$(220) + CHR$(12) + CHR$(240)
               ELSEIF RIGHT$(WORD$, 3) = "A'U" OR RIGHT$(WORD$, 3) = "I'U" OR RIGHT$(WORD$, 3) = "U'U" OR RIGHT$(WORD$, 3) = "E'U" OR RIGHT$(WORD$, 3) = "O'U" THEN
                  WORD$ = LEFT$(WORD$, LEN(WORD$) - 2)
                  WORDRIGHT$ = CHR$(240) + CHR$(55) + CHR$(12) + CHR$(240) + CHR$(240) + CHR$(161) + CHR$(12) + CHR$(240)
               ELSEIF RIGHT$(WORD$, 3) = "A'O" OR RIGHT$(WORD$, 3) = "I'O" OR RIGHT$(WORD$, 3) = "U'O" OR RIGHT$(WORD$, 3) = "E'O" OR RIGHT$(WORD$, 3) = "O'O" THEN
                  WORD$ = LEFT$(WORD$, LEN(WORD$) - 2)
                  WORDRIGHT$ = CHR$(240) + CHR$(55) + CHR$(12) + CHR$(240) + CHR$(240) + CHR$(235) + CHR$(12) + CHR$(240)
               ELSEIF RIGHT$(WORD$, 1) = "S" THEN
                  WORD$ = LEFT$(WORD$, LEN(WORD$) - 1)
                  WORDRIGHT$ = CHR$(240) + CHR$(60) + CHR$(12) + CHR$(240)
               ELSEIF RIGHT$(WORD$, 1) = "R" THEN
                  WORD$ = LEFT$(WORD$, LEN(WORD$) - 1)
                  WORDRIGHT$ = CHR$(240) + CHR$(57) + CHR$(12) + CHR$(240)
               ELSE
'Word-part will not be found by special methods, therefore is "NOT FOUND"            
                  GOTO 180
               END IF
'Special searches begin in common word list        
               FOR c% = 1 TO numrec4%
                  IF WORD$ = SHORTLIST$(c%, 1) THEN
                     FLAGPREVIOUS$ = "WORDFOUND"
                     PRINT #2, SHORTLIST$(c%, 2); WORDRIGHT$;
                     GOTO 200
                  END IF
               NEXT
'Not found in common word list so look in long word list
               FOR c% = beginrec% TO totalrec%
                  IF WORD$ = RTRIM$(LONGLIST(c%).WORD) THEN
                     FLAGPREVIOUS$ = "WORDFOUND"
                     a$ = RTRIM$(LONGLIST(c%).NUMBER)
                     FOR n% = 1 TO LEN(a$) / 2
                        PRINT #2, CHR$(240); MID$(a$, 2 * n% - 1, 2); CHR$(240);
                     NEXT
                     PRINT #2, WORDRIGHT$;
                     GOTO 200
                  END IF
               NEXT
'Word was not found to set a flag and output the unknown contents of the ACIP file
180            FLAGPREVIOUS$ = "WORDNOTFOUND"
               PRINT #2, WORD$;
'hidden text code with the text in the centre of the string
PRINT #2, CHR$(212); CHR$(66); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212); CHR$(141); "[n]"; CHR$(142); CHR$(212); CHR$(67); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212);
               GOTO 200
            END IF
         LOOP
      ELSE
         PRINT #2, FIRSTCHAR$;
      END IF
   END IF


'This next section deals with the conversion and output of all the
'individual characters which could not be Tibetan word parts.  They are
'dealt with on an individual basis, starting with most common and ending
'with least common.
200 SELECT CASE ASC(CH$)
'ACIP space is either a tsheg or a space
      CASE IS = 32
         IF FLAGPREVIOUS$ = "WORDFOUND" OR FLAGPREVIOUS$ = "WORDNOTFOUND" THEN
            PRINT #2, CHR$(132);
            FLAGPREVIOUS$ = ""
         ELSE
            PRINT #2, CHR$(128);
         END IF
'ACIP comma is a shad
      CASE IS = 44
         PRINT #2, "/";
'Deal with CR which is the first character of CR/LFEED.
'Look for multiple CR/LF's with a loop and flag.
'Print conversion progress based on appearance of CR/LF's and
'number of characters read in from ACIP file.  (Keeps the logic
'out of the main input loop and so speeds things up).
      CASE IS = 13
         CH$ = INPUT$(1, 1): bytesinput = bytesinput + 1
         SELECT CASE FLAGPREVIOUS$
            CASE IS = "WORDFOUND", IS = "WORDNOTFOUND"
'tsheg then hidden text code with the text in the centre of the string
PRINT #2, CHR$(132); CHR$(212); CHR$(66); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212); CHR$(141); "[t]"; CHR$(142); CHR$(212); CHR$(67); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212);
            CASE IS = "HRT"
'hidden text code with the text in the centre of the string
PRINT #2, CHR$(212); CHR$(66); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212); CHR$(141); "[h]"; CHR$(142); CHR$(212); CHR$(67); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212);
            CASE ELSE
'space then hidden text code with the text in the centre of the string
PRINT #2, CHR$(128); CHR$(212); CHR$(66); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212); CHR$(141); "[s]"; CHR$(142); CHR$(212); CHR$(67); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212);
         END SELECT
         FLAGPREVIOUS$ = "HRT"
         IF bytesinput - bytecounter > 1024 THEN
            LOCATE , 14: PRINT USING "###"; INT(bytesinput / LOF(1) * 100);
            bytecounter = bytesinput
         END IF
         GOTO 300
'pass through all numerals 
      CASE IS = 48, 49, IS = 50, IS = 51, IS = 52, IS = 53, IS = 54, IS = 55, IS = 56, IS = 57
         PRINT #2, CH$;
'now deal with individual signs
      CASE IS = 35
         PRINT #2, CHR$(240); CHR$(201); CHR$(12); CHR$(240); CHR$(240); CHR$(200); CHR$(12); CHR$(240);
      CASE IS = 58
         PRINT #2, CHR$(240); CHR$(239); CHR$(12); CHR$(240);
      CASE IS = 59
         PRINT #2, CHR$(240); CHR$(203); CHR$(12); CHR$(240);
      CASE IS = 42
         PRINT #2, CHR$(240); CHR$(201); CHR$(12); CHR$(240);
      CASE IS = 64
'hard return then leave character @ in file
         PRINT #2, CHR$(204); "@";
      CASE IS = 65, IS = 66
         PRINT #2, CH$;
      CASE IS = 92
         PRINT #2, CHR$(240); CHR$(252); CHR$(12); CHR$(240);
      CASE IS = 96
         PRINT #2, CHR$(240); CHR$(204); CHR$(12); CHR$(240);
      CASE IS = 94, IS = 36, IS = 37, IS = 47
'characters need a manual fix; hidden text code with the text in the centre of the string
PRINT #2, CH$; CHR$(212); CHR$(66); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212); CHR$(141); "[m]"; CHR$(142); CHR$(212); CHR$(67); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212);
      CASE IS = 40
'start yig chung manual fix; hidden text code with the text in the centre of the string
PRINT #2, CH$; CHR$(212); CHR$(66); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212); CHR$(141); "[yigchungstart]"; CHR$(142); CHR$(212); CHR$(67); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212 _
);
      CASE IS = 41
'end yig chung manual fix; hidden text code with the text in the centre of the string
PRINT #2, CH$; CHR$(212); CHR$(66); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212); CHR$(141); "[yigchungend]"; CHR$(142); CHR$(212); CHR$(67); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212); _

      CASE ELSE
'characters not known; hidden text code with the text in the centre of the string
PRINT #2, CH$; CHR$(212); CHR$(66); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212); CHR$(141); "[u]"; CHR$(142); CHR$(212); CHR$(67); CHR$(10); CHR$(0); CHR$(3); CHR$(0); CHR$(0); CHR$(10); CHR$(0); CHR$(212);
      END SELECT
      FLAGPREVIOUS$ = ""
300 LOOP
LOCATE , 2: PRINT "                       "
PRINT " The conversion is complete:"; INT(TIMER - Timetaken); "seconds @ ";
PRINT USING "#.###"; bytesinput / (1000 * INT(TIMER - Timetaken));
PRINT " Kbytes/sec."

