/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PApplet;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PVector;

public final class PMatrix3D
implements PMatrix {
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;
    protected PMatrix3D inverseCopy;

    public PMatrix3D() {
        this.reset();
    }

    public PMatrix3D(float f, float f2, float f3, float f4, float f5, float f6) {
        this.set(f, f2, f3, 0.0f, f4, f5, f6, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public PMatrix3D(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.set(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public PMatrix3D(PMatrix pMatrix) {
        this.set(pMatrix);
    }

    public void reset() {
        this.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public PMatrix3D get() {
        PMatrix3D pMatrix3D = new PMatrix3D();
        pMatrix3D.set(this);
        return pMatrix3D;
    }

    public float[] get(float[] fArray) {
        if (fArray == null || fArray.length != 16) {
            fArray = new float[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33};
        }
        return fArray;
    }

    public void set(PMatrix pMatrix) {
        if (pMatrix instanceof PMatrix3D) {
            PMatrix3D pMatrix3D = (PMatrix3D)pMatrix;
            this.set(pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m03, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m13, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22, pMatrix3D.m23, pMatrix3D.m30, pMatrix3D.m31, pMatrix3D.m32, pMatrix3D.m33);
        } else {
            PMatrix2D pMatrix2D = (PMatrix2D)pMatrix;
            this.set(pMatrix2D.m00, pMatrix2D.m01, 0.0f, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, 0.0f, pMatrix2D.m12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    public void set(float[] fArray) {
        if (fArray.length == 6) {
            this.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
        } else if (fArray.length == 16) {
            this.m00 = fArray[0];
            this.m01 = fArray[1];
            this.m02 = fArray[2];
            this.m03 = fArray[3];
            this.m10 = fArray[4];
            this.m11 = fArray[5];
            this.m12 = fArray[6];
            this.m13 = fArray[7];
            this.m20 = fArray[8];
            this.m21 = fArray[9];
            this.m22 = fArray[10];
            this.m23 = fArray[11];
            this.m30 = fArray[12];
            this.m31 = fArray[13];
            this.m32 = fArray[14];
            this.m33 = fArray[15];
        }
    }

    public void set(float f, float f2, float f3, float f4, float f5, float f6) {
        this.set(f, f2, 0.0f, f3, f4, f5, 0.0f, f6, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
        this.m30 = f13;
        this.m31 = f14;
        this.m32 = f15;
        this.m33 = f16;
    }

    public void translate(float f, float f2) {
        this.translate(f, f2, 0.0f);
    }

    public void translate(float f, float f2, float f3) {
        this.m03 += f * this.m00 + f2 * this.m01 + f3 * this.m02;
        this.m13 += f * this.m10 + f2 * this.m11 + f3 * this.m12;
        this.m23 += f * this.m20 + f2 * this.m21 + f3 * this.m22;
        this.m33 += f * this.m30 + f2 * this.m31 + f3 * this.m32;
    }

    public void rotate(float f) {
        this.rotateZ(f);
    }

    public void rotateX(float f) {
        float f2 = this.cos(f);
        float f3 = this.sin(f);
        this.apply(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, f2, -f3, 0.0f, 0.0f, f3, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void rotateY(float f) {
        float f2 = this.cos(f);
        float f3 = this.sin(f);
        this.apply(f2, 0.0f, f3, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -f3, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void rotateZ(float f) {
        float f2 = this.cos(f);
        float f3 = this.sin(f);
        this.apply(f2, -f3, 0.0f, 0.0f, f3, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        float f5 = this.cos(f);
        float f6 = this.sin(f);
        float f7 = 1.0f - f5;
        this.apply(f7 * f2 * f2 + f5, f7 * f2 * f3 - f6 * f4, f7 * f2 * f4 + f6 * f3, 0.0f, f7 * f2 * f3 + f6 * f4, f7 * f3 * f3 + f5, f7 * f3 * f4 - f6 * f2, 0.0f, f7 * f2 * f4 - f6 * f3, f7 * f3 * f4 + f6 * f2, f7 * f4 * f4 + f5, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void scale(float f) {
        this.scale(f, f, f);
    }

    public void scale(float f, float f2) {
        this.scale(f, f2, 1.0f);
    }

    public void scale(float f, float f2, float f3) {
        this.m00 *= f;
        this.m01 *= f2;
        this.m02 *= f3;
        this.m10 *= f;
        this.m11 *= f2;
        this.m12 *= f3;
        this.m20 *= f;
        this.m21 *= f2;
        this.m22 *= f3;
        this.m30 *= f;
        this.m31 *= f2;
        this.m32 *= f3;
    }

    public void skewX(float f) {
        float f2 = (float)Math.tan(f);
        this.apply(1.0f, f2, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void skewY(float f) {
        float f2 = (float)Math.tan(f);
        this.apply(1.0f, 0.0f, 0.0f, 0.0f, f2, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void apply(PMatrix pMatrix) {
        if (pMatrix instanceof PMatrix2D) {
            this.apply((PMatrix2D)pMatrix);
        } else if (pMatrix instanceof PMatrix3D) {
            this.apply((PMatrix3D)pMatrix);
        }
    }

    public void apply(PMatrix2D pMatrix2D) {
        this.apply(pMatrix2D.m00, pMatrix2D.m01, 0.0f, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, 0.0f, pMatrix2D.m12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void apply(PMatrix3D pMatrix3D) {
        this.apply(pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m03, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m13, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22, pMatrix3D.m23, pMatrix3D.m30, pMatrix3D.m31, pMatrix3D.m32, pMatrix3D.m33);
    }

    public void apply(float f, float f2, float f3, float f4, float f5, float f6) {
        this.apply(f, f2, 0.0f, f3, f4, f5, 0.0f, f6, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void apply(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        float f17 = this.m00 * f + this.m01 * f5 + this.m02 * f9 + this.m03 * f13;
        float f18 = this.m00 * f2 + this.m01 * f6 + this.m02 * f10 + this.m03 * f14;
        float f19 = this.m00 * f3 + this.m01 * f7 + this.m02 * f11 + this.m03 * f15;
        float f20 = this.m00 * f4 + this.m01 * f8 + this.m02 * f12 + this.m03 * f16;
        float f21 = this.m10 * f + this.m11 * f5 + this.m12 * f9 + this.m13 * f13;
        float f22 = this.m10 * f2 + this.m11 * f6 + this.m12 * f10 + this.m13 * f14;
        float f23 = this.m10 * f3 + this.m11 * f7 + this.m12 * f11 + this.m13 * f15;
        float f24 = this.m10 * f4 + this.m11 * f8 + this.m12 * f12 + this.m13 * f16;
        float f25 = this.m20 * f + this.m21 * f5 + this.m22 * f9 + this.m23 * f13;
        float f26 = this.m20 * f2 + this.m21 * f6 + this.m22 * f10 + this.m23 * f14;
        float f27 = this.m20 * f3 + this.m21 * f7 + this.m22 * f11 + this.m23 * f15;
        float f28 = this.m20 * f4 + this.m21 * f8 + this.m22 * f12 + this.m23 * f16;
        float f29 = this.m30 * f + this.m31 * f5 + this.m32 * f9 + this.m33 * f13;
        float f30 = this.m30 * f2 + this.m31 * f6 + this.m32 * f10 + this.m33 * f14;
        float f31 = this.m30 * f3 + this.m31 * f7 + this.m32 * f11 + this.m33 * f15;
        float f32 = this.m30 * f4 + this.m31 * f8 + this.m32 * f12 + this.m33 * f16;
        this.m00 = f17;
        this.m01 = f18;
        this.m02 = f19;
        this.m03 = f20;
        this.m10 = f21;
        this.m11 = f22;
        this.m12 = f23;
        this.m13 = f24;
        this.m20 = f25;
        this.m21 = f26;
        this.m22 = f27;
        this.m23 = f28;
        this.m30 = f29;
        this.m31 = f30;
        this.m32 = f31;
        this.m33 = f32;
    }

    public void preApply(PMatrix2D pMatrix2D) {
        this.preApply(pMatrix2D.m00, pMatrix2D.m01, 0.0f, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, 0.0f, pMatrix2D.m12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void preApply(PMatrix3D pMatrix3D) {
        this.preApply(pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m03, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m13, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22, pMatrix3D.m23, pMatrix3D.m30, pMatrix3D.m31, pMatrix3D.m32, pMatrix3D.m33);
    }

    public void preApply(float f, float f2, float f3, float f4, float f5, float f6) {
        this.preApply(f, f2, 0.0f, f3, f4, f5, 0.0f, f6, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void preApply(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        float f17 = f * this.m00 + f2 * this.m10 + f3 * this.m20 + f4 * this.m30;
        float f18 = f * this.m01 + f2 * this.m11 + f3 * this.m21 + f4 * this.m31;
        float f19 = f * this.m02 + f2 * this.m12 + f3 * this.m22 + f4 * this.m32;
        float f20 = f * this.m03 + f2 * this.m13 + f3 * this.m23 + f4 * this.m33;
        float f21 = f5 * this.m00 + f6 * this.m10 + f7 * this.m20 + f8 * this.m30;
        float f22 = f5 * this.m01 + f6 * this.m11 + f7 * this.m21 + f8 * this.m31;
        float f23 = f5 * this.m02 + f6 * this.m12 + f7 * this.m22 + f8 * this.m32;
        float f24 = f5 * this.m03 + f6 * this.m13 + f7 * this.m23 + f8 * this.m33;
        float f25 = f9 * this.m00 + f10 * this.m10 + f11 * this.m20 + f12 * this.m30;
        float f26 = f9 * this.m01 + f10 * this.m11 + f11 * this.m21 + f12 * this.m31;
        float f27 = f9 * this.m02 + f10 * this.m12 + f11 * this.m22 + f12 * this.m32;
        float f28 = f9 * this.m03 + f10 * this.m13 + f11 * this.m23 + f12 * this.m33;
        float f29 = f13 * this.m00 + f14 * this.m10 + f15 * this.m20 + f16 * this.m30;
        float f30 = f13 * this.m01 + f14 * this.m11 + f15 * this.m21 + f16 * this.m31;
        float f31 = f13 * this.m02 + f14 * this.m12 + f15 * this.m22 + f16 * this.m32;
        float f32 = f13 * this.m03 + f14 * this.m13 + f15 * this.m23 + f16 * this.m33;
        this.m00 = f17;
        this.m01 = f18;
        this.m02 = f19;
        this.m03 = f20;
        this.m10 = f21;
        this.m11 = f22;
        this.m12 = f23;
        this.m13 = f24;
        this.m20 = f25;
        this.m21 = f26;
        this.m22 = f27;
        this.m23 = f28;
        this.m30 = f29;
        this.m31 = f30;
        this.m32 = f31;
        this.m33 = f32;
    }

    public PVector mult(PVector pVector, PVector pVector2) {
        if (pVector2 == null) {
            pVector2 = new PVector();
        }
        pVector2.x = this.m00 * pVector.x + this.m01 * pVector.y + this.m02 * pVector.z + this.m03;
        pVector2.y = this.m10 * pVector.x + this.m11 * pVector.y + this.m12 * pVector.z + this.m13;
        pVector2.z = this.m20 * pVector.x + this.m21 * pVector.y + this.m22 * pVector.z + this.m23;
        return pVector2;
    }

    public float[] mult(float[] fArray, float[] fArray2) {
        if (fArray2 == null || fArray2.length < 3) {
            fArray2 = new float[3];
        }
        if (fArray == fArray2) {
            throw new RuntimeException("The source and target vectors used in PMatrix3D.mult() cannot be identical.");
        }
        if (fArray2.length == 3) {
            fArray2[0] = this.m00 * fArray[0] + this.m01 * fArray[1] + this.m02 * fArray[2] + this.m03;
            fArray2[1] = this.m10 * fArray[0] + this.m11 * fArray[1] + this.m12 * fArray[2] + this.m13;
            fArray2[2] = this.m20 * fArray[0] + this.m21 * fArray[1] + this.m22 * fArray[2] + this.m23;
        } else if (fArray2.length > 3) {
            fArray2[0] = this.m00 * fArray[0] + this.m01 * fArray[1] + this.m02 * fArray[2] + this.m03 * fArray[3];
            fArray2[1] = this.m10 * fArray[0] + this.m11 * fArray[1] + this.m12 * fArray[2] + this.m13 * fArray[3];
            fArray2[2] = this.m20 * fArray[0] + this.m21 * fArray[1] + this.m22 * fArray[2] + this.m23 * fArray[3];
            fArray2[3] = this.m30 * fArray[0] + this.m31 * fArray[1] + this.m32 * fArray[2] + this.m33 * fArray[3];
        }
        return fArray2;
    }

    public float multX(float f, float f2) {
        return this.m00 * f + this.m01 * f2 + this.m03;
    }

    public float multY(float f, float f2) {
        return this.m10 * f + this.m11 * f2 + this.m13;
    }

    public float multX(float f, float f2, float f3) {
        return this.m00 * f + this.m01 * f2 + this.m02 * f3 + this.m03;
    }

    public float multY(float f, float f2, float f3) {
        return this.m10 * f + this.m11 * f2 + this.m12 * f3 + this.m13;
    }

    public float multZ(float f, float f2, float f3) {
        return this.m20 * f + this.m21 * f2 + this.m22 * f3 + this.m23;
    }

    public float multW(float f, float f2, float f3) {
        return this.m30 * f + this.m31 * f2 + this.m32 * f3 + this.m33;
    }

    public float multX(float f, float f2, float f3, float f4) {
        return this.m00 * f + this.m01 * f2 + this.m02 * f3 + this.m03 * f4;
    }

    public float multY(float f, float f2, float f3, float f4) {
        return this.m10 * f + this.m11 * f2 + this.m12 * f3 + this.m13 * f4;
    }

    public float multZ(float f, float f2, float f3, float f4) {
        return this.m20 * f + this.m21 * f2 + this.m22 * f3 + this.m23 * f4;
    }

    public float multW(float f, float f2, float f3, float f4) {
        return this.m30 * f + this.m31 * f2 + this.m32 * f3 + this.m33 * f4;
    }

    public void transpose() {
        float f = this.m01;
        this.m01 = this.m10;
        this.m10 = f;
        f = this.m02;
        this.m02 = this.m20;
        this.m20 = f;
        f = this.m03;
        this.m03 = this.m30;
        this.m30 = f;
        f = this.m12;
        this.m12 = this.m21;
        this.m21 = f;
        f = this.m13;
        this.m13 = this.m31;
        this.m31 = f;
        f = this.m23;
        this.m23 = this.m32;
        this.m32 = f;
    }

    public boolean invert() {
        float f = this.determinant();
        if (f == 0.0f) {
            return false;
        }
        float f2 = this.determinant3x3(this.m11, this.m12, this.m13, this.m21, this.m22, this.m23, this.m31, this.m32, this.m33);
        float f3 = -this.determinant3x3(this.m10, this.m12, this.m13, this.m20, this.m22, this.m23, this.m30, this.m32, this.m33);
        float f4 = this.determinant3x3(this.m10, this.m11, this.m13, this.m20, this.m21, this.m23, this.m30, this.m31, this.m33);
        float f5 = -this.determinant3x3(this.m10, this.m11, this.m12, this.m20, this.m21, this.m22, this.m30, this.m31, this.m32);
        float f6 = -this.determinant3x3(this.m01, this.m02, this.m03, this.m21, this.m22, this.m23, this.m31, this.m32, this.m33);
        float f7 = this.determinant3x3(this.m00, this.m02, this.m03, this.m20, this.m22, this.m23, this.m30, this.m32, this.m33);
        float f8 = -this.determinant3x3(this.m00, this.m01, this.m03, this.m20, this.m21, this.m23, this.m30, this.m31, this.m33);
        float f9 = this.determinant3x3(this.m00, this.m01, this.m02, this.m20, this.m21, this.m22, this.m30, this.m31, this.m32);
        float f10 = this.determinant3x3(this.m01, this.m02, this.m03, this.m11, this.m12, this.m13, this.m31, this.m32, this.m33);
        float f11 = -this.determinant3x3(this.m00, this.m02, this.m03, this.m10, this.m12, this.m13, this.m30, this.m32, this.m33);
        float f12 = this.determinant3x3(this.m00, this.m01, this.m03, this.m10, this.m11, this.m13, this.m30, this.m31, this.m33);
        float f13 = -this.determinant3x3(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m30, this.m31, this.m32);
        float f14 = -this.determinant3x3(this.m01, this.m02, this.m03, this.m11, this.m12, this.m13, this.m21, this.m22, this.m23);
        float f15 = this.determinant3x3(this.m00, this.m02, this.m03, this.m10, this.m12, this.m13, this.m20, this.m22, this.m23);
        float f16 = -this.determinant3x3(this.m00, this.m01, this.m03, this.m10, this.m11, this.m13, this.m20, this.m21, this.m23);
        float f17 = this.determinant3x3(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
        this.m00 = f2 / f;
        this.m01 = f6 / f;
        this.m02 = f10 / f;
        this.m03 = f14 / f;
        this.m10 = f3 / f;
        this.m11 = f7 / f;
        this.m12 = f11 / f;
        this.m13 = f15 / f;
        this.m20 = f4 / f;
        this.m21 = f8 / f;
        this.m22 = f12 / f;
        this.m23 = f16 / f;
        this.m30 = f5 / f;
        this.m31 = f9 / f;
        this.m32 = f13 / f;
        this.m33 = f17 / f;
        return true;
    }

    private float determinant3x3(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return f * (f5 * f9 - f6 * f8) + f2 * (f6 * f7 - f4 * f9) + f3 * (f4 * f8 - f5 * f7);
    }

    public float determinant() {
        float f = this.m00 * (this.m11 * this.m22 * this.m33 + this.m12 * this.m23 * this.m31 + this.m13 * this.m21 * this.m32 - this.m13 * this.m22 * this.m31 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33);
        f -= this.m01 * (this.m10 * this.m22 * this.m33 + this.m12 * this.m23 * this.m30 + this.m13 * this.m20 * this.m32 - this.m13 * this.m22 * this.m30 - this.m10 * this.m23 * this.m32 - this.m12 * this.m20 * this.m33);
        f += this.m02 * (this.m10 * this.m21 * this.m33 + this.m11 * this.m23 * this.m30 + this.m13 * this.m20 * this.m31 - this.m13 * this.m21 * this.m30 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33);
        return f -= this.m03 * (this.m10 * this.m21 * this.m32 + this.m11 * this.m22 * this.m30 + this.m12 * this.m20 * this.m31 - this.m12 * this.m21 * this.m30 - this.m10 * this.m22 * this.m31 - this.m11 * this.m20 * this.m32);
    }

    protected void invTranslate(float f, float f2, float f3) {
        this.preApply(1.0f, 0.0f, 0.0f, -f, 0.0f, 1.0f, 0.0f, -f2, 0.0f, 0.0f, 1.0f, -f3, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected void invRotateX(float f) {
        float f2 = this.cos(-f);
        float f3 = this.sin(-f);
        this.preApply(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, f2, -f3, 0.0f, 0.0f, f3, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected void invRotateY(float f) {
        float f2 = this.cos(-f);
        float f3 = this.sin(-f);
        this.preApply(f2, 0.0f, f3, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -f3, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected void invRotateZ(float f) {
        float f2 = this.cos(-f);
        float f3 = this.sin(-f);
        this.preApply(f2, -f3, 0.0f, 0.0f, f3, f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected void invRotate(float f, float f2, float f3, float f4) {
        float f5 = this.cos(-f);
        float f6 = this.sin(-f);
        float f7 = 1.0f - f5;
        this.preApply(f7 * f2 * f2 + f5, f7 * f2 * f3 - f6 * f4, f7 * f2 * f4 + f6 * f3, 0.0f, f7 * f2 * f3 + f6 * f4, f7 * f3 * f3 + f5, f7 * f3 * f4 - f6 * f2, 0.0f, f7 * f2 * f4 - f6 * f3, f7 * f3 * f4 + f6 * f2, f7 * f4 * f4 + f5, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected void invScale(float f, float f2, float f3) {
        this.preApply(1.0f / f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f3, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected boolean invApply(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        if (this.inverseCopy == null) {
            this.inverseCopy = new PMatrix3D();
        }
        this.inverseCopy.set(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        if (!this.inverseCopy.invert()) {
            return false;
        }
        this.preApply(this.inverseCopy);
        return true;
    }

    public void print() {
        int n = (int)Math.abs(this.max(this.max(this.max(this.max(this.abs(this.m00), this.abs(this.m01)), this.max(this.abs(this.m02), this.abs(this.m03))), this.max(this.max(this.abs(this.m10), this.abs(this.m11)), this.max(this.abs(this.m12), this.abs(this.m13)))), this.max(this.max(this.max(this.abs(this.m20), this.abs(this.m21)), this.max(this.abs(this.m22), this.abs(this.m23))), this.max(this.max(this.abs(this.m30), this.abs(this.m31)), this.max(this.abs(this.m32), this.abs(this.m33))))));
        int n2 = 1;
        if (Float.isNaN(n) || Float.isInfinite(n)) {
            n2 = 5;
        } else {
            while ((n /= 10) != 0) {
                ++n2;
            }
        }
        System.out.println(PApplet.nfs(this.m00, n2, 4) + " " + PApplet.nfs(this.m01, n2, 4) + " " + PApplet.nfs(this.m02, n2, 4) + " " + PApplet.nfs(this.m03, n2, 4));
        System.out.println(PApplet.nfs(this.m10, n2, 4) + " " + PApplet.nfs(this.m11, n2, 4) + " " + PApplet.nfs(this.m12, n2, 4) + " " + PApplet.nfs(this.m13, n2, 4));
        System.out.println(PApplet.nfs(this.m20, n2, 4) + " " + PApplet.nfs(this.m21, n2, 4) + " " + PApplet.nfs(this.m22, n2, 4) + " " + PApplet.nfs(this.m23, n2, 4));
        System.out.println(PApplet.nfs(this.m30, n2, 4) + " " + PApplet.nfs(this.m31, n2, 4) + " " + PApplet.nfs(this.m32, n2, 4) + " " + PApplet.nfs(this.m33, n2, 4));
        System.out.println();
    }

    private final float max(float f, float f2) {
        return f > f2 ? f : f2;
    }

    private final float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    private final float sin(float f) {
        return (float)Math.sin(f);
    }

    private final float cos(float f) {
        return (float)Math.cos(f);
    }
}

