/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public abstract class UnicodeEncoder
extends CharsetEncoder {
    protected static final char BYTE_ORDER_MARK = '\ufeff';
    protected static final char REVERSED_MARK = '\ufffe';
    protected static final int BIG = 0;
    protected static final int LITTLE = 1;
    private int byteOrder;
    private boolean usesMark;
    private boolean needsMark;
    private final Surrogate.Parser sgp;

    protected UnicodeEncoder(Charset charset, int n, boolean bl) {
        byte[] byArray;
        float f = bl ? 4.0f : 2.0f;
        if (n == 0) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            byArray = byArray2;
            byArray2[1] = -3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = -3;
            byArray = byArray3;
            byArray3[1] = -1;
        }
        super(charset, 2.0f, f, byArray);
        this.sgp = new Surrogate.Parser();
        this.usesMark = this.needsMark = bl;
        this.byteOrder = n;
    }

    private void put(char c, ByteBuffer byteBuffer) {
        if (this.byteOrder == 0) {
            byteBuffer.put((byte)(c >> 8));
            byteBuffer.put((byte)(c & 0xFF));
        } else {
            byteBuffer.put((byte)(c & 0xFF));
            byteBuffer.put((byte)(c >> 8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        if (this.needsMark) {
            if (byteBuffer.remaining() < 2) {
                return CoderResult.OVERFLOW;
            }
            this.put('\ufeff', byteBuffer);
            this.needsMark = false;
        }
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (!Surrogate.is(c)) {
                    if (byteBuffer.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    ++n;
                    this.put(c, byteBuffer);
                    continue;
                }
                int n2 = this.sgp.parse(c, charBuffer);
                if (n2 < 0) {
                    CoderResult coderResult = this.sgp.error();
                    return coderResult;
                }
                if (byteBuffer.remaining() < 4) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n += 2;
                this.put(Surrogate.high(n2), byteBuffer);
                this.put(Surrogate.low(n2), byteBuffer);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected void implReset() {
        this.needsMark = this.usesMark;
    }

    public boolean canEncode(char c) {
        return !Surrogate.is(c);
    }
}

