/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.AuthKey;
import com.sun.deploy.security.BrowserAuthenticator;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.CredentialManager;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.ui.ComponentRef;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.Trace;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.text.MessageFormat;

public class DeployAuthenticator
extends Authenticator
implements AuthKey {
    private static final String SCHEME_NTLM = "NTLM";
    private static final String SCHEME_DIGEST = "DIGEST";
    private static final String SCHEME_BASIC = "BASIC";
    private String ntlmDisplayString = this.getMessage("net.authenticate.ntlm.display.string");
    private String digestDisplayString = this.getMessage("net.authenticate.digest.display.string");
    private String basicDisplayString = this.getMessage("net.authenticate.basic.display.string");
    private String unknownDisplayString = this.getMessage("net.authenticate.unknown.display.string");
    private final long CANCEL_DURATION = 3000L;
    private final int ACTIVE = 1;
    private final int CANCEL = 2;
    protected ComponentRef parentComponent = null;
    private CredentialManager cm;
    private boolean cmInitialized;
    private StateMonitor stateMonitor = new StateMonitor();

    private CredentialManager getCredentialManager() {
        if (!this.cmInitialized) {
            this.cmInitialized = true;
            this.cm = ServiceManager.getService().getCredentialManager();
        }
        return this.cm;
    }

    private BrowserAuthenticator getBrowserAuthenticator() {
        Service service = ServiceManager.getService();
        return service.getBrowserAuthenticator();
    }

    protected synchronized PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication passwordAuthentication = null;
        if (Config.isJavaVersionAtLeast15()) {
            this.getCredentialManager();
            if (this.stateMonitor.getState(CredentialManager.buildConnectionKey(this)) == 2) {
                return null;
            }
        }
        try {
            String string;
            InetAddress inetAddress = this.getRequestingSite();
            if (inetAddress != null) {
                string = inetAddress.toString();
            } else {
                string = this.getHost();
                if (string == null || string.length() == 0) {
                    string = this.getMessage("net.authenticate.unknownSite");
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Firewall authentication: site=");
            stringBuffer.append(this.getRequestingSite());
            stringBuffer.append(":" + this.getRequestingPort());
            stringBuffer.append(", protocol=");
            stringBuffer.append(this.getRequestingProtocol());
            stringBuffer.append(", prompt=");
            stringBuffer.append(this.getRequestingPrompt());
            stringBuffer.append(", scheme=");
            stringBuffer.append(this.getRequestingScheme());
            Trace.netPrintln(stringBuffer.toString());
            CredentialInfo credentialInfo = new CredentialInfo();
            CredentialInfo credentialInfo2 = null;
            if (Config.isJavaVersionAtLeast15()) {
                if (this.getCredentialManager() != null) {
                    credentialInfo = this.getCredentialManager().getCredential(this);
                }
                if (credentialInfo.isCredentialEmpty() || !this.getCredentialManager().isCredentialValid(credentialInfo)) {
                    credentialInfo = CredentialInfo.passAuthToCredentialInfo(this.getBrowserCredential());
                    if (this.getCredentialManager() != null) {
                        credentialInfo.setSessionId(this.getCredentialManager().getLoginSessionId());
                    }
                }
                if (this.getCredentialManager() == null || !this.getCredentialManager().isCredentialValid(credentialInfo)) {
                    credentialInfo2 = this.openDialog(string, this.getRequestingPrompt(), this.getRequestingScheme(), credentialInfo);
                    if (credentialInfo2 != null) {
                        this.getCredentialManager().saveCredential(this, credentialInfo2);
                        passwordAuthentication = credentialInfo2.getPasswordAuthentication();
                    } else {
                        this.getCredentialManager();
                        this.stateMonitor.setCancel(CredentialManager.buildConnectionKey(this));
                    }
                } else {
                    passwordAuthentication = credentialInfo.getPasswordAuthentication();
                }
            } else {
                credentialInfo2 = this.openDialog(string, this.getRequestingPrompt(), this.getRequestingScheme(), credentialInfo);
                passwordAuthentication = credentialInfo2.getPasswordAuthentication();
            }
        }
        catch (Exception exception) {
            Trace.netPrintException(exception);
        }
        return passwordAuthentication;
    }

    private PasswordAuthentication getBrowserCredential() {
        PasswordAuthentication passwordAuthentication = null;
        BrowserAuthenticator browserAuthenticator = this.getBrowserAuthenticator();
        if (browserAuthenticator != null) {
            passwordAuthentication = browserAuthenticator.getAuthentication(this.getRequestingProtocol(), this.getHost(), this.getRequestingPort(), this.getRequestingScheme(), this.getRequestingPrompt(), this.getURL(), this.isProxy());
        }
        return passwordAuthentication;
    }

    private CredentialInfo openDialog(String string, String string2, String string3, CredentialInfo credentialInfo) {
        if (string == null) {
            string = "";
        }
        if (string2 == null || string2.trim().equals("")) {
            string2 = "<default>";
        }
        boolean bl = false;
        String string4 = this.unknownDisplayString;
        if (string3 != null) {
            if (string3.equalsIgnoreCase(SCHEME_BASIC)) {
                string4 = this.basicDisplayString;
            } else if (string3.equalsIgnoreCase(SCHEME_DIGEST)) {
                string4 = this.digestDisplayString;
            } else if (string3.equalsIgnoreCase(SCHEME_NTLM)) {
                string4 = this.ntlmDisplayString;
                bl = true;
            } else {
                string4 = this.unknownDisplayString;
            }
        }
        MessageFormat messageFormat = new MessageFormat(this.getMessage("net.authenticate.text"));
        Object[] objectArray = new Object[]{string2, string};
        String string5 = messageFormat.format(objectArray);
        CredentialInfo credentialInfo2 = null;
        boolean bl2 = false;
        if (this.getCredentialManager() != null) {
            bl2 = this.getCredentialManager().isPasswordEncryptionSupported();
        }
        try {
            credentialInfo2 = UIFactory.showPasswordDialog(this.parentComponent == null ? null : this.parentComponent.get(), this.getMessage("password.dialog.title"), string5, true, bl, credentialInfo, bl2, string4);
        }
        catch (Exception exception) {
            Trace.securityPrintException(exception);
        }
        return credentialInfo2;
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void setParentComponent(ComponentRef componentRef) {
        this.parentComponent = componentRef;
    }

    public String getProtocolScheme() {
        return this.getRequestingProtocol();
    }

    public String getHost() {
        try {
            return this.getRequestingHost();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return "";
        }
    }

    public int getPort() {
        return this.getRequestingPort();
    }

    public String getPath() {
        URL uRL = this.getURL();
        if (uRL != null) {
            return uRL.getPath();
        }
        return null;
    }

    public boolean isProxy() {
        try {
            return this.getRequestorType() == Authenticator.RequestorType.PROXY;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    public URL getURL() {
        try {
            return this.getRequestingURL();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
    }

    private class StateMonitor {
        private int currentState = 1;
        private long timeOfLastCancel = 0L;
        private String siteKey = "";

        private StateMonitor() {
        }

        private void setCancel(String string) {
            this.currentState = 2;
            this.timeOfLastCancel = System.currentTimeMillis();
            this.siteKey = this.trimPath(string);
        }

        private int getState(String string) {
            int n = 1;
            if (this.currentState == 2) {
                if (System.currentTimeMillis() - this.timeOfLastCancel > 3000L) {
                    this.currentState = 1;
                } else if (string.startsWith(this.siteKey)) {
                    n = 2;
                }
            }
            return n;
        }

        public String trimPath(String string) {
            int n = string.lastIndexOf(47);
            String string2 = string.substring(0, n + 1);
            return string2;
        }
    }
}

