/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import java.util.Objects;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import org.pdfsam.ui.selection.multiple.SelectionTableRowData;
import org.sejda.commons.util.RequireUtils;

class TooltippedTextFieldTableCell
extends TableCell<SelectionTableRowData, String> {
    private Tooltip tooltip = new Tooltip();
    private final TextField textField = new TextField();
    private StringConverter<String> converter = new DefaultStringConverter();

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (Objects.nonNull(item) && Objects.nonNull(this.tooltip)) {
            this.setTooltip(this.tooltip);
        } else {
            this.setTooltip(null);
        }
    }

    public TooltippedTextFieldTableCell(String tooltipMessage) {
        RequireUtils.requireNotBlank((String)tooltipMessage, (String)"Tooltiped cell must have a tooltip message");
        this.tooltip.setText(tooltipMessage);
        this.itemProperty().addListener((obx, oldItem, newItem) -> {
            if (newItem == null) {
                this.setText(null);
            } else {
                this.setText(this.converter.toString(newItem));
            }
        });
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.textField.setOnAction(evt -> this.commitEdit((String)this.converter.fromString(this.textField.getText())));
        this.textField.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (!isNowFocused.booleanValue()) {
                this.commitEdit((String)this.converter.fromString(this.textField.getText()));
            }
        });
        this.textField.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                this.textField.setText(this.converter.toString((Object)((String)this.getItem())));
                this.cancelEdit();
                event.consume();
            } else if (event.getCode() == KeyCode.RIGHT) {
                this.getTableView().getSelectionModel().selectRightCell();
                event.consume();
            } else if (event.getCode() == KeyCode.LEFT) {
                this.getTableView().getSelectionModel().selectLeftCell();
                event.consume();
            } else if (event.getCode() == KeyCode.UP) {
                this.getTableView().getSelectionModel().selectAboveCell();
                event.consume();
            } else if (event.getCode() == KeyCode.DOWN) {
                this.getTableView().getSelectionModel().selectBelowCell();
                event.consume();
            }
        });
    }

    public void startEdit() {
        super.startEdit();
        this.textField.setText(this.converter.toString((Object)((String)this.getItem())));
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    public void commitEdit(String item) {
        TableView table;
        if (!this.isEditing() && !item.equals(this.getItem()) && (table = this.getTableView()) != null) {
            TableColumn column = this.getTableColumn();
            TableColumn.CellEditEvent event = new TableColumn.CellEditEvent(table, new TablePosition(table, this.getIndex(), column), TableColumn.editCommitEvent(), (Object)item);
            Event.fireEvent((EventTarget)column, (Event)event);
        }
        super.commitEdit((Object)item);
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }
}

