/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import java.util.Comparator;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Labeled;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.ui.commons.ShowStageRequest;
import org.pdfsam.ui.selection.LoadingStatusIndicatorUpdater;
import org.pdfsam.ui.selection.ShowPasswordFieldPopupRequest;
import org.pdfsam.ui.selection.multiple.SelectionTableColumn;
import org.pdfsam.ui.selection.multiple.SelectionTableRowData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadingColumn
implements SelectionTableColumn<PdfDescriptorLoadingStatus>,
ModuleOwned {
    private static final Logger LOG = LoggerFactory.getLogger(LoadingColumn.class);
    private String ownerModule = "";

    public LoadingColumn(String ownerModule) {
        this.ownerModule = StringUtils.defaultString((String)ownerModule);
    }

    public String getOwnerModule() {
        return this.ownerModule;
    }

    @Override
    public String getColumnTitle() {
        return null;
    }

    @Override
    public ObservableValue<PdfDescriptorLoadingStatus> getObservableValue(SelectionTableRowData data) {
        return data.descriptor().loadingStatus();
    }

    @Override
    public String getTextValue(PdfDescriptorLoadingStatus item) {
        return item != null && item.getIcon() != null ? item.getIcon().toString() : "";
    }

    @Override
    public Callback<TableColumn<SelectionTableRowData, PdfDescriptorLoadingStatus>, TableCell<SelectionTableRowData, PdfDescriptorLoadingStatus>> cellFactory() {
        return new Callback<TableColumn<SelectionTableRowData, PdfDescriptorLoadingStatus>, TableCell<SelectionTableRowData, PdfDescriptorLoadingStatus>>(){

            public TableCell<SelectionTableRowData, PdfDescriptorLoadingStatus> call(TableColumn<SelectionTableRowData, PdfDescriptorLoadingStatus> param) {
                return new LoadingStatusCell();
            }
        };
    }

    @Override
    public Comparator<PdfDescriptorLoadingStatus> comparator() {
        return Comparator.naturalOrder();
    }

    @Override
    public TableColumn<SelectionTableRowData, PdfDescriptorLoadingStatus> getTableColumn() {
        TableColumn tableColumn = new TableColumn(this.getColumnTitle());
        tableColumn.setCellFactory(this.cellFactory());
        tableColumn.setCellValueFactory(this.cellValueFactory());
        tableColumn.setComparator(null);
        tableColumn.setSortable(false);
        tableColumn.setMaxWidth(26.0);
        tableColumn.setMinWidth(26.0);
        return tableColumn;
    }

    private class LoadingStatusCell
    extends TableCell<SelectionTableRowData, PdfDescriptorLoadingStatus> {
        private LoadingStatusIndicatorUpdater updater;

        LoadingStatusCell() {
            this.getStyleClass().addAll((Object[])new String[]{"encryption-status"});
            this.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
                if (this.getItem() == PdfDescriptorLoadingStatus.ENCRYPTED) {
                    StaticStudio.eventStudio().broadcast((Object)new ShowPasswordFieldPopupRequest(this.getPdfDocumentDescriptor(), (Region)this), LoadingColumn.this.getOwnerModule());
                } else if (this.getItem() == PdfDescriptorLoadingStatus.WITH_ERRORS) {
                    StaticStudio.eventStudio().broadcast((Object)ShowStageRequest.INSTANCE, "LogStage");
                }
            });
            this.updater = new LoadingStatusIndicatorUpdater((Labeled)this);
        }

        public void updateItem(PdfDescriptorLoadingStatus item, boolean empty) {
            super.updateItem((Object)item, empty);
            LOG.trace("Updating idicator for new status {} for row {}", (Object)item, (Object)this.getTableRow().getIndex());
            this.updater.accept(item);
        }

        public PdfDocumentDescriptor getPdfDocumentDescriptor() {
            return ((SelectionTableRowData)this.getTableRow().getItem()).descriptor();
        }
    }
}

