/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.utils.FontAwesomeIconFactory;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.layout.HBox;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.ui.selection.PasswordFieldPopupSkin;
import org.pdfsam.ui.support.Style;

public class PasswordFieldPopup
extends PopupControl
implements ModuleOwned {
    private String ownerModule = "";
    private PasswordFieldPopupContent content = new PasswordFieldPopupContent();
    private PdfDocumentDescriptor pdfDescriptor;

    public PasswordFieldPopup(String ownerModule) {
        this.ownerModule = StringUtils.defaultString((String)ownerModule);
        this.getStyleClass().setAll((Object[])new String[]{"pdfsam-input-password"});
        this.setAutoHide(true);
        this.setHideOnEscape(true);
        this.setAutoFix(true);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    public String getOwnerModule() {
        return this.ownerModule;
    }

    PasswordFieldPopupContent getPopupContent() {
        return this.content;
    }

    protected Skin<?> createDefaultSkin() {
        return new PasswordFieldPopupSkin(this);
    }

    public void showFor(Node owner, PdfDocumentDescriptor pdfDescriptor, double anchorX, double anchorY) {
        this.pdfDescriptor = pdfDescriptor;
        this.show(owner, anchorX, anchorY);
    }

    private class PasswordFieldPopupContent
    extends HBox {
        private PasswordField passwordField = new PasswordField();

        public PasswordFieldPopupContent() {
            this.getStyleClass().setAll((Object[])new String[]{"pdfsam-input-password-content"});
            this.passwordField.setPromptText(DefaultI18nContext.getInstance().i18n("Enter the user password"));
            Button doneButton = FontAwesomeIconFactory.get().createIconButton((GlyphIcons)FontAwesomeIcon.UNLOCK, DefaultI18nContext.getInstance().i18n("Unlock"));
            doneButton.getStyleClass().addAll((Object[])Style.BUTTON.css());
            doneButton.prefHeightProperty().bind((ObservableValue)this.passwordField.heightProperty());
            doneButton.setMaxHeight(Double.NEGATIVE_INFINITY);
            doneButton.setMinHeight(Double.NEGATIVE_INFINITY);
            doneButton.setOnAction(e -> this.requestLoad());
            this.passwordField.setOnAction(e -> this.requestLoad());
            this.getChildren().addAll((Object[])new Node[]{this.passwordField, doneButton});
        }

        public void requestLoad() {
            if (PasswordFieldPopup.this.pdfDescriptor != null) {
                PasswordFieldPopup.this.pdfDescriptor.setPassword(this.passwordField.getText());
                PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(PasswordFieldPopup.this.getOwnerModule());
                loadEvent.add(PasswordFieldPopup.this.pdfDescriptor);
                StaticStudio.eventStudio().broadcast((Object)loadEvent);
            }
            this.passwordField.clear();
            PasswordFieldPopup.this.hide();
        }
    }
}

