/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.utils.FontAwesomeIconFactory;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Labeled;
import javafx.scene.control.Tooltip;
import org.pdfsam.pdf.PdfDescriptorLoadingStatus;
import org.sejda.commons.util.RequireUtils;
import org.sejda.commons.util.StringUtils;

public class LoadingStatusIndicatorUpdater
implements Consumer<PdfDescriptorLoadingStatus> {
    private Labeled indicator;

    public LoadingStatusIndicatorUpdater(Labeled indicator) {
        RequireUtils.requireNotNullArg((Object)indicator, (String)"Cannot set loading status on a null indicator");
        this.indicator = indicator;
    }

    @Override
    public void accept(PdfDescriptorLoadingStatus t) {
        FontAwesomeIcon icon = Optional.ofNullable(t).map(PdfDescriptorLoadingStatus::getIcon).orElse(null);
        if (Objects.nonNull(icon)) {
            FontAwesomeIconFactory.get().setIcon(this.indicator, (GlyphIcons)icon, ContentDisplay.CENTER);
        } else {
            this.indicator.setGraphic(null);
        }
        Arrays.stream(PdfDescriptorLoadingStatus.values()).map(PdfDescriptorLoadingStatus::getStyle).filter(StringUtils::isNotEmpty).forEach(arg_0 -> this.indicator.getStyleClass().remove(arg_0));
        if (Objects.nonNull(t) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)t.getStyle())) {
            this.indicator.getStyleClass().add((Object)t.getStyle());
        }
        if (Objects.nonNull(t) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)t.getDescription())) {
            this.indicator.setTooltip(new Tooltip(t.getDescription()));
        } else {
            this.indicator.setTooltip(null);
        }
    }
}

