/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.module;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.utils.MaterialDesignIconFactory;
import javafx.scene.control.Button;
import javafx.scene.control.Labeled;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.injector.Prototype;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.ui.support.Style;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;

@Prototype
public class RunButton
extends Button {
    public RunButton() {
        this.getStyleClass().addAll((Object[])Style.RUN_BUTTON.css());
        this.setText(DefaultI18nContext.getInstance().i18n("Run"));
        MaterialDesignIconFactory.get().setIcon((Labeled)this, (GlyphIcons)MaterialDesignIcon.PLAY, "2.0em");
        this.setMaxHeight(Double.MAX_VALUE);
        this.setPrefHeight(Double.MAX_VALUE);
        this.setDefaultButton(true);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void disableRunButtonIfTaskRequested(TaskExecutionRequestEvent event) {
        this.setDisable(true);
    }

    @EventListener
    public void enableRunButtonOnTaskCompletion(TaskExecutionCompletedEvent event) {
        this.setDisable(false);
    }

    @EventListener
    public void enableRunButtonOnTaskFailure(TaskExecutionFailedEvent event) {
        this.setDisable(false);
    }
}

