/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.module;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.utils.FontAwesomeIconFactory;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.utils.MaterialDesignIconFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitMenuButton;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.eventstudio.ReferenceStrength;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.Module;
import org.pdfsam.module.ModuleInputOutputType;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.ui.commons.ClearModuleEvent;
import org.pdfsam.ui.commons.OpenFileRequest;
import org.pdfsam.ui.commons.SetActiveModuleRequest;
import org.pdfsam.ui.support.Style;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.FileOrDirectoryTaskOutput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenButton
extends SplitMenuButton
implements TaskOutputDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(OpenButton.class);
    private String ownerModule = "";
    private File destination;
    private List<File> latestOutput = new ArrayList<File>();
    private ModuleInputOutputType outputType;

    public OpenButton(String ownerModule, ModuleInputOutputType outputType) {
        Objects.requireNonNull(outputType);
        this.outputType = outputType;
        this.ownerModule = StringUtils.defaultString((String)ownerModule);
        this.setId(ownerModule + ".openButton");
        this.getStyleClass().addAll((Object[])Style.BUTTON.css());
        this.getStyleClass().addAll((Object[])new String[]{"pdfsam-split-button", "footer-open-button"});
        this.setText(DefaultI18nContext.getInstance().i18n("Open"));
        this.setMaxHeight(Double.MAX_VALUE);
        this.setPrefHeight(Double.MAX_VALUE);
        this.setVisible(false);
        this.setOnAction(e -> {
            if (this.latestOutput.size() != 1 || !this.openFile(this.latestOutput.get(0))) {
                this.openFile(this.destination);
            }
        });
        StaticStudio.eventStudio().add(TaskExecutionRequestEvent.class, e -> {
            if (e.getModuleId().equals(ownerModule)) {
                this.latestOutput.clear();
                try {
                    if (!Objects.isNull(e.getParameters().getOutput())) {
                        e.getParameters().getOutput().accept((TaskOutputDispatcher)this);
                    }
                }
                catch (TaskOutputVisitException ex) {
                    LOG.warn("This should never happen", (Throwable)ex);
                }
            }
        }, -10, ReferenceStrength.STRONG);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    private boolean openFile(File file) {
        if (file != null && file.exists()) {
            StaticStudio.eventStudio().broadcast((Object)new OpenFileRequest(file));
            return true;
        }
        return false;
    }

    public void initModules(Collection<Module> modules) {
        modules.forEach(m -> {
            if (m.descriptor().hasInputType(this.outputType)) {
                this.getItems().add((Object)new OpenWithMenuItem((Module)m));
            }
        });
    }

    @EventStation
    public String getOwnerModule() {
        return this.ownerModule;
    }

    @EventListener(priority=-10)
    public void onTaskCompleted(TaskExecutionCompletedEvent event) {
        this.latestOutput.addAll(event.getNotifiableTaskMetadata().taskOutput());
    }

    public void dispatch(FileTaskOutput output) {
        this.destination = output.getDestination();
        this.setGraphic((Node)FontAwesomeIconFactory.get().createIcon((GlyphIcons)FontAwesomeIcon.FILE_PDF_ALT, "1.6em"));
    }

    public void dispatch(DirectoryTaskOutput output) {
        this.destination = output.getDestination();
        this.setGraphic((Node)MaterialDesignIconFactory.get().createIcon((GlyphIcons)MaterialDesignIcon.FOLDER_OUTLINE, "1.6em"));
    }

    public void dispatch(FileOrDirectoryTaskOutput output) {
        this.destination = output.getDestination();
        this.setGraphic((Node)MaterialDesignIconFactory.get().createIcon((GlyphIcons)MaterialDesignIcon.FOLDER_OUTLINE, "1.6em"));
    }

    private class OpenWithMenuItem
    extends MenuItem {
        private OpenWithMenuItem(Module module) {
            this.setText(module.descriptor().getName());
            this.setOnAction(e -> {
                StaticStudio.eventStudio().broadcast((Object)new ClearModuleEvent(module.id()), module.id());
                StaticStudio.eventStudio().broadcast((Object)SetActiveModuleRequest.activeteModule(module.id()));
                PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(module.id());
                OpenButton.this.latestOutput.stream().map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(arg_0 -> ((PdfLoadRequestEvent)loadEvent).add(arg_0));
                StaticStudio.eventStudio().broadcast((Object)loadEvent, module.id());
            });
        }
    }
}

