/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.module;

import java.math.BigDecimal;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.ui.module.OpenButton;
import org.pdfsam.ui.module.RunButton;
import org.pdfsam.ui.module.TaskFailedButton;
import org.sejda.model.notification.event.PercentageOfWorkDoneChangedEvent;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;

public class Footer
extends HBox
implements ModuleOwned {
    private ProgressBar bar = new ProgressBar(0.0);
    private Label statusLabel = new Label();
    private TaskFailedButton failed = new TaskFailedButton();
    private OpenButton openButton;
    private RunButton runButton;
    private String ownerModule = "";

    public Footer(RunButton runButton, OpenButton openButton, String ownerModule) {
        this.ownerModule = StringUtils.defaultString((String)ownerModule);
        this.openButton = openButton;
        this.runButton = runButton;
        this.getStyleClass().addAll((Object[])new String[]{"pdfsam-container", "footer-pane"});
        this.statusLabel.getStyleClass().add((Object)"status-label");
        this.statusLabel.setVisible(false);
        this.bar.setMaxWidth(Double.MAX_VALUE);
        this.bar.getStyleClass().add((Object)"pdfsam-footer-bar");
        this.statusLabel.setMaxHeight(Double.MAX_VALUE);
        VBox progressPane = new VBox(new Node[]{this.statusLabel, this.bar});
        progressPane.getStyleClass().add((Object)"progress-pane");
        VBox.setVgrow((Node)this.statusLabel, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.bar, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)progressPane, (Priority)Priority.ALWAYS);
        this.failed.setVisible(false);
        StackPane buttons = new StackPane(new Node[]{this.failed, openButton});
        buttons.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().addAll((Object[])new Node[]{runButton, buttons, progressPane});
        StaticStudio.eventStudio().add(TaskExecutionRequestEvent.class, e -> {
            if (e.getModuleId().equals(ownerModule)) {
                this.failed.setVisible(false);
                openButton.setVisible(false);
                this.statusLabel.setVisible(true);
                this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Requested"));
                this.bar.setProgress(0.0);
            }
        });
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    public OpenButton openButton() {
        return this.openButton;
    }

    public RunButton runButton() {
        return this.runButton;
    }

    @EventStation
    public String getOwnerModule() {
        return this.ownerModule;
    }

    @EventListener
    public void onTaskCompleted(TaskExecutionCompletedEvent event) {
        this.failed.setVisible(false);
        this.openButton.setVisible(true);
        this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Completed"));
        this.bar.setProgress(1.0);
    }

    @EventListener
    public void onTaskFailed(TaskExecutionFailedEvent event) {
        this.openButton.setVisible(false);
        this.failed.setVisible(true);
        this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Failed"));
    }

    @EventListener
    public void onProgress(PercentageOfWorkDoneChangedEvent event) {
        this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Running"));
        if (event.isUndetermined()) {
            this.bar.setProgress(-1.0);
        } else {
            this.bar.setProgress(event.getPercentage().divide(new BigDecimal(100)).doubleValue());
            this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Running {0}%", Integer.toString(event.getPercentage().intValue())));
        }
    }
}

