/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.module;

import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.builder.Builder;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.Module;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.ui.module.Footer;
import org.pdfsam.ui.module.RunButtonTriggerRequest;
import org.pdfsam.ui.notification.AddNotificationRequestEvent;
import org.pdfsam.ui.notification.NotificationType;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.LoadWorkspaceEvent;
import org.pdfsam.ui.workspace.SaveWorkspaceEvent;
import org.sejda.model.parameter.base.AbstractParameters;

public abstract class BaseTaskExecutionModule
implements Module {
    private BorderPane modulePanel = new BorderPane();
    private Footer footer;

    public BaseTaskExecutionModule(Footer footer) {
        this.footer = footer;
    }

    protected final void initModuleSettingsPanel(VBox panel) {
        panel.getStyleClass().addAll((Object[])Style.DEAULT_CONTAINER.css());
        panel.getStyleClass().addAll((Object[])Style.MODULE_CONTAINER.css());
        panel.getChildren().add((Object)this.footer);
        this.footer.runButton().setOnAction(event -> {
            ErrorTracker errorTracker = new ErrorTracker();
            Builder<? extends AbstractParameters> builder = this.getBuilder(errorTracker.andThen(s -> StaticStudio.eventStudio().broadcast((Object)new AddNotificationRequestEvent(NotificationType.ERROR, (String)s, DefaultI18nContext.getInstance().i18n("Invalid parameters")))));
            if (!errorTracker.errorOnBuild) {
                StaticStudio.eventStudio().broadcast((Object)new TaskExecutionRequestEvent(this.id(), (AbstractParameters)builder.build()));
            }
        });
        this.modulePanel.setCenter((Node)panel);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public final void saveStateData(SaveWorkspaceEvent event) {
        this.onSaveWorkspace(event.getDataForModule(this.id()));
    }

    @EventListener
    public final void restoreState(LoadWorkspaceEvent event) {
        Platform.runLater(() -> this.onLoadWorkspace(event.getData(this.id())));
    }

    @EventListener
    public void onRunButtonAccelerator(RunButtonTriggerRequest request) {
        this.footer.runButton().fire();
    }

    protected abstract Builder<? extends AbstractParameters> getBuilder(Consumer<String> var1);

    public Pane modulePanel() {
        return this.modulePanel;
    }

    private static class ErrorTracker
    implements Consumer<String> {
        boolean errorOnBuild = false;

        private ErrorTracker() {
        }

        @Override
        public void accept(String error) {
            this.errorOnBuild = true;
        }
    }
}

