/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.commons;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.utils.FontAwesomeIconFactory;
import java.util.Objects;
import javafx.scene.control.Button;
import javafx.scene.control.Labeled;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.ui.commons.OpenUrlRequest;
import org.pdfsam.ui.support.Style;
import org.sejda.commons.util.RequireUtils;

public class UrlButton
extends Button {
    private UrlButton(String text) {
        super(text);
    }

    public static final UrlButton styledUrlButton(String text, String url, FontAwesomeIcon icon) {
        return UrlButton.urlButton(text, url, icon, Style.BUTTON.css());
    }

    public static final UrlButton urlButton(String text, String url, FontAwesomeIcon icon, String ... style) {
        RequireUtils.requireNotBlank((String)url, (String)"URL cannot be blank");
        UrlButton button = new UrlButton(text);
        button.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new OpenUrlRequest(url)));
        if (Objects.nonNull(icon)) {
            FontAwesomeIconFactory.get().setIcon((Labeled)button, (GlyphIcons)icon);
        }
        if (Objects.nonNull(style) && style.length > 0) {
            button.getStyleClass().addAll((Object[])style);
        }
        return button;
    }
}

