/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.commons.util;

import java.io.File;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sejda.commons.util.StringUtils;

public class NumericalSortFilenameComparator
implements Comparator<File> {
    private static Pattern PATTERN = Pattern.compile("^(\\d*)(.*)(\\d*)$");
    private static Function<String, BigInteger> DIGITS_EXTRACTOR = g -> Optional.ofNullable(g).filter(StringUtils::isNotEmpty).map(BigInteger::new).orElse(null);
    private static Comparator<String> BIG_INT_COMPARATOR = (a, b) -> {
        BigInteger bigA = DIGITS_EXTRACTOR.apply((String)a);
        BigInteger bigB = DIGITS_EXTRACTOR.apply((String)b);
        if (Objects.nonNull(bigA) && Objects.nonNull(bigB)) {
            return bigA.compareTo(bigB);
        }
        return 0;
    };
    private static Comparator<String> STRING_COMPARATOR = (a, b) -> {
        if (StringUtils.isNotEmpty(a) && StringUtils.isNotEmpty(b)) {
            return a.compareToIgnoreCase((String)b);
        }
        return 0;
    };
    private static Comparator<Matcher> MATCHER_COMPARATOR = Comparator.comparing(m -> m.group(1), BIG_INT_COMPARATOR).thenComparing(Comparator.comparing(m -> m.group(2), STRING_COMPARATOR)).thenComparing(Comparator.comparing(m -> m.group(3), BIG_INT_COMPARATOR));
    private Comparator<File> fallback;

    private static String basename(File file) {
        if (Objects.nonNull(file)) {
            String filename = file.getName();
            int index = filename.lastIndexOf(46);
            if (index > 0) {
                return filename.substring(0, index);
            }
            if (StringUtils.isNotEmpty(filename)) {
                return filename;
            }
        }
        return null;
    }

    public NumericalSortFilenameComparator(Comparator<File> fallback) {
        this.fallback = Optional.ofNullable(fallback).orElse(Comparator.nullsLast(Comparator.comparing(File::getName, String.CASE_INSENSITIVE_ORDER)));
    }

    public NumericalSortFilenameComparator() {
        this(null);
    }

    @Override
    public int compare(File a, File b) {
        Matcher m1 = Optional.ofNullable(a).map(NumericalSortFilenameComparator::basename).map(PATTERN::matcher).filter(Matcher::matches).orElse(null);
        Matcher m2 = Optional.ofNullable(b).map(NumericalSortFilenameComparator::basename).map(PATTERN::matcher).filter(Matcher::matches).orElse(null);
        if (Objects.nonNull(m1) && Objects.nonNull(m2) && StringUtils.isEmpty(m1.group(1)) ^ StringUtils.isEmpty(m2.group(1))) {
            return this.fallback.compare(a, b);
        }
        int retVal = Comparator.nullsLast(MATCHER_COMPARATOR).compare(m1, m2);
        if (retVal == 0) {
            return this.fallback.compare(a, b);
        }
        return retVal;
    }
}

