/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.commons.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.sejda.commons.FastByteArrayOutputStream;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static void close(Closeable closeable) throws IOException {
        if (Objects.nonNull(closeable)) {
            closeable.close();
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (Objects.nonNull(closeable)) {
                closeable.close();
            }
        }
        catch (IOException ioe) {
            LOG.warn("An error occured while closing a Closeable resource", (Throwable)ioe);
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        try (FastByteArrayOutputStream output = new FastByteArrayOutputStream();){
            IOUtils.copy(input, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int read;
        RequireUtils.requireNotNullArg(input, "Cannot copy a null input");
        RequireUtils.requireNotNullArg(output, "Cannot copy to a null output");
        byte[] buffer = new byte[8192];
        while ((read = input.read(buffer, 0, 8192)) >= 0) {
            output.write(buffer, 0, read);
        }
    }
}

