/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.log;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.pdfsam.configuration.StylesConfig;
import org.pdfsam.eventstudio.Listener;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.ui.commons.ClosePane;
import org.pdfsam.ui.commons.HideStageRequest;
import org.pdfsam.ui.commons.ShowStageRequest;
import org.pdfsam.ui.log.LogListView;
import org.pdfsam.ui.log.LogPane;
import org.pdfsam.ui.support.Style;

@Auto
public class LogStage
extends Stage {
    @EventStation
    public static final String LOGSTAGE_EVENTSTATION = "LogStage";

    @Inject
    public LogStage(LogPane logPane, LogListView logView, List<Image> logos, StylesConfig styles) {
        BorderPane containerPane = new BorderPane();
        containerPane.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        containerPane.setCenter((Node)logPane);
        containerPane.setBottom((Node)new ClosePane(a -> StaticStudio.eventStudio().broadcast((Object)HideStageRequest.INSTANCE, LOGSTAGE_EVENTSTATION)));
        Scene scene = new Scene((Parent)containerPane);
        scene.getStylesheets().addAll(styles.styles());
        scene.setOnKeyReleased(k -> {
            if (this.isShowing() && new KeyCodeCombination(KeyCode.ESCAPE, new KeyCombination.Modifier[0]).match(k)) {
                StaticStudio.eventStudio().broadcast((Object)HideStageRequest.INSTANCE, LOGSTAGE_EVENTSTATION);
            }
        });
        this.setScene(scene);
        this.setTitle(DefaultI18nContext.getInstance().i18n("Log register"));
        this.getIcons().addAll(logos);
        this.setMaximized(true);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        this.onShowingProperty().addListener((o, oldVal, newVal) -> logView.scrollToBottomIfShowing());
        StaticStudio.eventStudio().add((Listener)logView, LOGSTAGE_EVENTSTATION);
    }

    @EventListener
    void requestShow(ShowStageRequest event) {
        if (!this.isShowing()) {
            this.centerOnScreen();
            this.show();
        }
        this.requestFocus();
    }

    @EventListener
    void requestHide(HideStageRequest event) {
        if (this.isShowing()) {
            this.hide();
        }
    }
}

