/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import java.util.Objects;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.ui.log.ErrorLoggedEvent;
import org.pdfsam.ui.log.LogLevel;
import org.pdfsam.ui.log.LogMessage;
import org.slf4j.LoggerFactory;

public class LogMessageBroadcaster
extends AppenderBase<ILoggingEvent> {
    private PatternLayoutEncoder encoder;

    public LogMessageBroadcaster(PatternLayoutEncoder encoder) {
        this.encoder = encoder;
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        encoder.setContext((Context)loggerContext);
        this.setContext((Context)loggerContext);
        encoder.start();
        ((LoggerContext)this.getContext()).getLogger("ROOT").addAppender((Appender)this);
    }

    public void append(ILoggingEvent event) {
        if (!this.isStarted()) {
            return;
        }
        Layout layout = this.encoder.getLayout();
        if (Objects.nonNull(layout)) {
            this.doAppendMessage(this.encoder.getLayout().doLayout((Object)event), event);
        }
    }

    private void doAppendMessage(String message, ILoggingEvent event) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            try (Scanner scanner = new Scanner(message);){
                while (scanner.hasNextLine()) {
                    StaticStudio.eventStudio().broadcast((Object)new LogMessage(scanner.nextLine(), LogLevel.toLogLevel(event.getLevel().toInt())), "LogStage");
                }
            }
            if (event.getLevel().isGreaterOrEqual(Level.ERROR)) {
                StaticStudio.eventStudio().broadcast((Object)new ErrorLoggedEvent());
            }
        }
    }

    public PatternLayoutEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(PatternLayoutEncoder encoder) {
        this.encoder = encoder;
    }
}

