/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.log;

import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.inject.Inject;
import org.pdfsam.context.UserContext;
import org.pdfsam.eventstudio.Listener;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.ui.log.LogLevel;
import org.pdfsam.ui.log.LogMessage;
import org.pdfsam.ui.log.MaxLogRowsChangedEvent;
import org.pdfsam.ui.support.CircularObservableList;

class LogListView
extends ListView<LogMessage>
implements Listener<LogMessage> {
    @Inject
    public LogListView(UserContext userContext) {
        CircularObservableList items = new CircularObservableList(userContext.getNumberOfLogRows());
        StaticStudio.eventStudio().add(MaxLogRowsChangedEvent.class, e -> items.setMaxCapacity(userContext.getNumberOfLogRows()));
        this.setId("log-view");
        this.setItems((ObservableList)items);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setCellFactory((Callback)new Callback<ListView<LogMessage>, ListCell<LogMessage>>(){

            public ListCell<LogMessage> call(ListView<LogMessage> list) {
                return new TextCell();
            }
        });
    }

    public void onEvent(LogMessage event) {
        Platform.runLater(() -> {
            this.getItems().add((Object)event);
            this.scrollToBottomIfShowing();
        });
    }

    public void scrollToBottomIfShowing() {
        if (!this.getItems().isEmpty() && Optional.ofNullable(this.getScene()).map(Scene::getWindow).map(Window::isShowing).orElse(Boolean.TRUE).booleanValue()) {
            this.scrollTo(this.getItems().size() - 1);
        }
    }

    static class TextCell
    extends ListCell<LogMessage> {
        TextCell() {
        }

        public void updateItem(LogMessage item, boolean empty) {
            super.updateItem((Object)item, empty);
            for (LogLevel current : LogLevel.values()) {
                this.getStyleClass().remove((Object)current.style());
            }
            if (Objects.nonNull(item)) {
                this.setText(item.getMessage());
                this.getStyleClass().add((Object)item.getLevel().style());
            } else {
                this.setText("");
            }
        }
    }
}

