/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.info;

import java.io.File;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Label;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.ui.commons.ShowPdfDescriptorRequest;
import org.pdfsam.ui.info.BaseInfoTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SummaryTab
extends BaseInfoTab
implements ChangeListener<PdfDescriptorLoadingStatus> {
    private static final Logger LOG = LoggerFactory.getLogger(SummaryTab.class);
    private static FastDateFormat FORMATTER = FastDateFormat.getDateTimeInstance((int)0, (int)2);
    private Label fileLabel = SummaryTab.createValueLabel();
    private Label size = SummaryTab.createValueLabel();
    private Label version = SummaryTab.createValueLabel();
    private Label created = SummaryTab.createValueLabel();
    private Label modified = SummaryTab.createValueLabel();
    private Label pages = SummaryTab.createValueLabel();
    private Label title = SummaryTab.createValueLabel();
    private Label author = SummaryTab.createValueLabel();
    private Label creator = SummaryTab.createValueLabel();
    private Label producer = SummaryTab.createValueLabel();
    private Label subject = SummaryTab.createValueLabel();
    private PdfDocumentDescriptor current;

    SummaryTab() {
        this.setText(DefaultI18nContext.getInstance().i18n("Summary"));
        this.grid().add((Node)SummaryTab.createTitleLabel("File"), 0, 0);
        this.grid().add((Node)this.fileLabel, 1, 0);
        this.grid().add((Node)SummaryTab.createTitleLabel("Size"), 0, 1);
        this.grid().add((Node)this.size, 1, 1);
        this.grid().add((Node)SummaryTab.createTitleLabel("Created"), 0, 2);
        this.grid().add((Node)this.created, 1, 2);
        this.grid().add((Node)SummaryTab.createTitleLabel("Modified"), 0, 3);
        this.grid().add((Node)this.modified, 1, 3);
        this.grid().add((Node)SummaryTab.createTitleLabel("PDF version"), 0, 4);
        this.grid().add((Node)this.version, 1, 4);
        this.grid().add((Node)SummaryTab.createTitleLabel("Pages"), 0, 5);
        this.grid().add((Node)this.pages, 1, 5);
        this.grid().add((Node)SummaryTab.createTitleLabel("Title"), 0, 6);
        this.grid().add((Node)this.title, 1, 6);
        this.grid().add((Node)SummaryTab.createTitleLabel("Author"), 0, 7);
        this.grid().add((Node)this.author, 1, 7);
        this.grid().add((Node)SummaryTab.createTitleLabel("Creator"), 0, 8);
        this.grid().add((Node)this.creator, 1, 8);
        this.grid().add((Node)SummaryTab.createTitleLabel("Producer"), 0, 9);
        this.grid().add((Node)this.producer, 1, 9);
        this.grid().add((Node)SummaryTab.createTitleLabel("Subject"), 0, 10);
        this.grid().add((Node)this.subject, 1, 10);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    void requestShow(ShowPdfDescriptorRequest event) {
        if (this.current != event.getDescriptor()) {
            this.current = event.getDescriptor();
            this.current.loadingStatus().addListener((ChangeListener)new WeakChangeListener((ChangeListener)this));
        }
        this.setFileProperties(this.current.getFile());
        this.setPdfProperties();
    }

    private void setFileProperties(File file) {
        this.fileLabel.setText(file.getAbsolutePath());
        this.size.setText(FileUtils.byteCountToDisplaySize((long)file.length()));
        this.modified.setText(FORMATTER.format(file.lastModified()));
    }

    private void setPdfProperties() {
        this.version.setText(this.current.getVersionString());
        this.pages.setText(Integer.toString((Integer)this.current.pages().getValue()));
        this.created.setText(this.current.getInformation("FormattedCreationDate"));
        this.title.setText(this.current.getInformation("Title"));
        this.author.setText(this.current.getInformation("Author"));
        this.creator.setText(this.current.getInformation("Creator"));
        this.subject.setText(this.current.getInformation("Subject"));
        this.producer.setText(this.current.getInformation("Producer"));
    }

    public void changed(ObservableValue<? extends PdfDescriptorLoadingStatus> observable, PdfDescriptorLoadingStatus oldValue, PdfDescriptorLoadingStatus newValue) {
        if (newValue == PdfDescriptorLoadingStatus.LOADED) {
            LOG.trace("Descriptor loaded, updating summary tab");
            Platform.runLater(() -> this.setPdfProperties());
        }
    }
}

