/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.info;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.layout.VBox;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.ui.commons.ShowPdfDescriptorRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeywordsTab
extends Tab
implements ChangeListener<PdfDescriptorLoadingStatus> {
    private static final Logger LOG = LoggerFactory.getLogger(KeywordsTab.class);
    private Label keywords = new Label();
    private PdfDocumentDescriptor current;

    KeywordsTab() {
        VBox content = new VBox();
        content.getStyleClass().add((Object)"info-props");
        this.setText(DefaultI18nContext.getInstance().i18n("Keywords"));
        this.setClosable(false);
        this.keywords.setWrapText(true);
        this.keywords.getStyleClass().add((Object)"info-property-value");
        content.getChildren().add((Object)this.keywords);
        ScrollPane scroll = new ScrollPane((Node)content);
        scroll.setFitToHeight(true);
        scroll.setFitToWidth(true);
        this.setContent((Node)scroll);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    void requestShow(ShowPdfDescriptorRequest event) {
        if (this.current != event.getDescriptor()) {
            this.current = event.getDescriptor();
            this.current.loadingStatus().addListener((ChangeListener)new WeakChangeListener((ChangeListener)this));
        }
        this.keywords.setText(event.getDescriptor().getInformation("Keywords"));
    }

    public void changed(ObservableValue<? extends PdfDescriptorLoadingStatus> observable, PdfDescriptorLoadingStatus oldValue, PdfDescriptorLoadingStatus newValue) {
        if (newValue == PdfDescriptorLoadingStatus.LOADED) {
            LOG.trace("Descriptor loaded, updating keywords tab");
            Platform.runLater(() -> this.keywords.setText(this.current.getInformation("Keywords")));
        }
    }
}

