/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dnd;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.pdf.MultipleFilesDroppedEvent;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfFilesListLoadRequest;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.support.io.FileType;
import org.pdfsam.ui.dialog.AddSubdirectoriesConfirmationDialog;
import org.pdfsam.ui.notification.AddNotificationRequestEvent;
import org.pdfsam.ui.notification.NotificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class MultipleFilesDropController {
    private static final Logger LOG = LoggerFactory.getLogger(MultipleFilesDropController.class);
    private Provider<AddSubdirectoriesConfirmationDialog> dialog;

    @Inject
    public MultipleFilesDropController(Provider<AddSubdirectoriesConfirmationDialog> dialog) {
        this.dialog = dialog;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void request(MultipleFilesDroppedEvent event) {
        if (event.files.size() == 1 && !((File)event.files.get(0)).isDirectory() && (FileType.TXT.matches(((File)event.files.get(0)).getName()) || FileType.CSV.matches(((File)event.files.get(0)).getName()))) {
            StaticStudio.eventStudio().broadcast((Object)new PdfFilesListLoadRequest(event.getOwnerModule(), ((File)event.files.get(0)).toPath()));
        } else {
            PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(event.getOwnerModule());
            this.getFiles(event.files).filter(f -> FileType.PDF.matches(f.getName())).map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(arg_0 -> ((PdfLoadRequestEvent)loadEvent).add(arg_0));
            if (!loadEvent.getDocuments().isEmpty()) {
                StaticStudio.eventStudio().broadcast((Object)loadEvent, event.getOwnerModule());
            } else {
                StaticStudio.eventStudio().broadcast((Object)new AddNotificationRequestEvent(NotificationType.WARN, DefaultI18nContext.getInstance().i18n("Drag and drop PDF files or directories containing PDF files"), DefaultI18nContext.getInstance().i18n("No PDF found")));
            }
        }
    }

    private Stream<File> getFiles(List<File> files) {
        if (files.size() == 1 && files.get(0).isDirectory()) {
            try {
                if (Arrays.stream(files.get(0).listFiles()).anyMatch(File::isDirectory) && ((AddSubdirectoriesConfirmationDialog)((Object)this.dialog.get())).response()) {
                    return Files.walk(files.get(0).toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).sorted();
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to retrieve the list of files from " + files.get(0), (Throwable)e);
            }
            return Arrays.stream(files.get(0).listFiles()).sorted();
        }
        return files.stream();
    }
}

