/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dialog;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.ArrayUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.exception.BroadcastInterruptionException;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.ui.dialog.OverwriteConfirmationDialog;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.FileOrDirectoryTaskOutput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.base.AbstractParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class OverwriteDialogController {
    private static final Logger LOG = LoggerFactory.getLogger(OverwriteDialogController.class);
    private Provider<OverwriteConfirmationDialog> dialog;

    @Inject
    public OverwriteDialogController(Provider<OverwriteConfirmationDialog> dialog) {
        this.dialog = dialog;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener(priority=-2147483648)
    public void request(TaskExecutionRequestEvent event) {
        final AbstractParameters params = event.getParameters();
        try {
            if (params.getExistingOutputPolicy() != ExistingOutputPolicy.OVERWRITE) {
                event.getParameters().getOutput().accept(new TaskOutputDispatcher(){

                    public void dispatch(FileOrDirectoryTaskOutput output) {
                        OverwriteDialogController.this.onDirectory(params, output.getDestination());
                    }

                    public void dispatch(DirectoryTaskOutput output) {
                        OverwriteDialogController.this.onDirectory(params, output.getDestination());
                    }

                    public void dispatch(FileTaskOutput output) {
                        OverwriteDialogController.this.onFile(params, output.getDestination());
                    }
                });
            }
        }
        catch (TaskOutputVisitException e) {
            LOG.warn("Unable to show overwrite confirmation dialog", (Throwable)e);
        }
    }

    private void onDirectory(AbstractParameters params, File dir) {
        if (ArrayUtils.isNotEmpty((Object[])dir.listFiles())) {
            I18nContext i18n = DefaultI18nContext.getInstance();
            OverwriteConfirmationDialog dlg = ((OverwriteConfirmationDialog)((Object)this.dialog.get())).init();
            ExistingOutputPolicy response = dlg.title(i18n.i18n("Directory not empty")).messageTitle(i18n.i18n("The selected directory is not empty")).messageContent(i18n.i18n("What would you like to do in case of files with the same name?")).buttons(dlg.defaultButton(i18n.i18n("Overwrite"), ExistingOutputPolicy.OVERWRITE), dlg.button(i18n.i18n("Rename"), ExistingOutputPolicy.RENAME), dlg.button(i18n.i18n("Skip"), ExistingOutputPolicy.SKIP), dlg.cancelButton(i18n.i18n("Cancel"))).response().orElseThrow(() -> new BroadcastInterruptionException(i18n.i18n("Don't overwrite existing file")));
            LOG.trace("Setting existing output policy to {}", (Object)response);
            params.setExistingOutputPolicy(response);
        }
    }

    private void onFile(AbstractParameters params, File file) {
        if (file.exists()) {
            I18nContext i18n = DefaultI18nContext.getInstance();
            OverwriteConfirmationDialog dlg = ((OverwriteConfirmationDialog)((Object)this.dialog.get())).init();
            ExistingOutputPolicy response = dlg.title(i18n.i18n("Overwrite confirmation")).messageTitle(i18n.i18n("A file with the given name already exists")).messageContent(i18n.i18n("What would you like to do?")).buttons(dlg.defaultButton(i18n.i18n("Overwrite"), ExistingOutputPolicy.OVERWRITE), dlg.button(i18n.i18n("Rename"), ExistingOutputPolicy.RENAME), dlg.cancelButton(i18n.i18n("Cancel"))).response().orElseThrow(() -> new BroadcastInterruptionException(i18n.i18n("Don't overwrite existing file")));
            LOG.trace("Setting existing output policy to {}", (Object)response);
            params.setExistingOutputPolicy(response);
        }
    }
}

