/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dialog;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javax.inject.Inject;
import org.pdfsam.configuration.StylesConfig;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.Module;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.ui.InputPdfArgumentsLoadRequest;
import org.pdfsam.ui.commons.ClearModuleEvent;
import org.pdfsam.ui.commons.HideOnEscapeHandler;
import org.pdfsam.ui.commons.SetActiveModuleRequest;
import org.pdfsam.ui.support.Style;

public class OpenWithDialog
extends Stage {
    private Label messageTitle = new Label();
    private HBox buttons = new HBox(5.0);
    private ListView<String> filesList = new ListView();
    private List<Module> modules;

    @Inject
    public OpenWithDialog(StylesConfig styles, List<Module> modules) {
        this.initModality(Modality.WINDOW_MODAL);
        this.initStyle(StageStyle.UTILITY);
        this.setResizable(false);
        this.setTitle(DefaultI18nContext.getInstance().i18n("Open with"));
        this.modules = modules.stream().sorted(Comparator.comparing(m -> m.descriptor().getName())).collect(Collectors.toList());
        this.messageTitle.getStyleClass().add((Object)"-pdfsam-open-with-dialog-title");
        BorderPane containerPane = new BorderPane();
        containerPane.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        containerPane.getStyleClass().addAll((Object[])new String[]{"-pdfsam-open-with-dialog", "-pdfsam-open-with-container"});
        containerPane.setTop((Node)this.messageTitle);
        BorderPane.setAlignment((Node)this.messageTitle, (Pos)Pos.TOP_CENTER);
        this.filesList.setPrefHeight(150.0);
        containerPane.setCenter(this.filesList);
        this.buttons.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        containerPane.setBottom((Node)this.buttons);
        BorderPane.setAlignment((Node)this.buttons, (Pos)Pos.CENTER);
        Scene scene = new Scene((Parent)containerPane);
        scene.getStylesheets().addAll(styles.styles());
        scene.setOnKeyReleased((EventHandler)new HideOnEscapeHandler((Window)this));
        this.setScene(scene);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    public void setOwner(Window owner) {
        this.initOwner(owner);
    }

    OpenWithDialog initFor(InputPdfArgumentsLoadRequest event) {
        this.messageTitle.setText(DefaultI18nContext.getInstance().i18n("Select the task to perform on the following files"));
        this.filesList.setItems(FXCollections.observableArrayList((Collection)event.pdfs.stream().map(Path::toString).collect(Collectors.toList())));
        this.modules.forEach(m -> {
            if (m.descriptor().hasInputType(event.requiredInputTyle())) {
                Button current = new Button(m.descriptor().getName());
                current.getStyleClass().addAll((Object[])Style.FOOTER_BUTTON.css());
                Optional.ofNullable(m.graphic()).ifPresent(g -> {
                    g.setScaleX(0.7);
                    g.setScaleY(0.7);
                    current.setGraphic(g);
                });
                current.setOnAction(e -> {
                    StaticStudio.eventStudio().broadcast((Object)new ClearModuleEvent(m.id()), m.id());
                    StaticStudio.eventStudio().broadcast((Object)SetActiveModuleRequest.activeteModule((String)m.id()));
                    this.hide();
                    PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(m.id());
                    event.pdfs.stream().map(Path::toFile).map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(arg_0 -> ((PdfLoadRequestEvent)loadEvent).add(arg_0));
                    StaticStudio.eventStudio().broadcast((Object)loadEvent, m.id());
                });
                this.buttons.getChildren().add((Object)current);
            }
        });
        return this;
    }
}

