/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.preference;

import java.util.Comparator;
import java.util.Locale;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.i18n.SetLocaleEvent;
import org.pdfsam.support.KeyStringValueItem;
import org.pdfsam.support.LocaleKeyValueItem;
import org.pdfsam.ui.dashboard.preference.ClearStatisticsButton;
import org.pdfsam.ui.dashboard.preference.PreferenceComboBox;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.support.Style;

class PreferenceAppearencePane
extends GridPane {
    @Inject
    public PreferenceAppearencePane(@Named(value="localeCombo") PreferenceComboBox<LocaleKeyValueItem> localeCombo, @Named(value="startupModuleCombo") PreferenceComboBox<KeyStringValueItem<String>> startupModuleCombo, ClearStatisticsButton clearStatsButton) {
        I18nContext i18n = DefaultI18nContext.getInstance();
        this.add((Node)new Label(i18n.i18n("Language:")), 0, 0);
        i18n.getSupportedLocales().stream().sorted(Comparator.comparing(Locale::getDisplayName)).map(LocaleKeyValueItem::new).forEach(arg_0 -> localeCombo.getItems().add(arg_0));
        localeCombo.setValue(new LocaleKeyValueItem(Locale.getDefault()));
        localeCombo.valueProperty().addListener((observable, oldValue, newValue) -> StaticStudio.eventStudio().broadcast((Object)new SetLocaleEvent(newValue.getKey())));
        localeCombo.setMaxWidth(Double.POSITIVE_INFINITY);
        PreferenceAppearencePane.setFillWidth(localeCombo, (Boolean)true);
        this.add((Node)localeCombo, 1, 0);
        this.add((Node)HelpUtils.helpIcon((String)i18n.i18n("Set your preferred language (restart needed)")), 2, 0);
        this.add((Node)new Label(i18n.i18n("Startup module:")), 0, 1);
        startupModuleCombo.setMaxWidth(Double.POSITIVE_INFINITY);
        PreferenceAppearencePane.setFillWidth(startupModuleCombo, (Boolean)true);
        this.add((Node)startupModuleCombo, 1, 1);
        this.add((Node)HelpUtils.helpIcon((String)i18n.i18n("Set the module to open at application startup (restart needed)")), 2, 1);
        GridPane statsPane = new GridPane();
        statsPane.add((Node)clearStatsButton, 0, 0);
        statsPane.add((Node)HelpUtils.helpIcon((String)i18n.i18n("Usage statistics are used to populate the modules quick bar on the left with the most used and most recently used modules.")), 1, 0);
        statsPane.getStyleClass().addAll((Object[])Style.GRID.css());
        this.add((Node)statsPane, 0, 3, 3, 1);
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.GRID.css());
    }
}

