/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.modules;

import java.util.List;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.Module;
import org.pdfsam.premium.PremiumModulesEvent;
import org.pdfsam.ui.dashboard.modules.ModulesDashboardTile;
import org.pdfsam.ui.dashboard.modules.PremiumModuleTile;

public class ModulesDashboardPane
extends VBox {
    @Inject
    public ModulesDashboardPane(List<Module> modules) {
        FlowPane modulesPane = new FlowPane();
        this.getStyleClass().addAll((Object[])new String[]{"dashboard-container"});
        modulesPane.getStyleClass().add((Object)"dashboard-modules");
        modules.stream().sorted((a, b) -> a.descriptor().getPriority() - b.descriptor().getPriority()).map(ModulesDashboardTile::new).forEach(arg_0 -> modulesPane.getChildren().add(arg_0));
        this.getChildren().add((Object)modulesPane);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onPremiumModules(PremiumModulesEvent e) {
        if (!e.premiumModules.isEmpty()) {
            Label premiumTile = new Label(DefaultI18nContext.getInstance().i18n("Premium features"));
            premiumTile.getStyleClass().add((Object)"modules-tile-title");
            FlowPane modulesPane = new FlowPane();
            modulesPane.getStyleClass().add((Object)"dashboard-modules");
            e.premiumModules.stream().sorted((a, b) -> a.getId() - b.getId()).map(PremiumModuleTile::new).forEach(arg_0 -> modulesPane.getChildren().add(arg_0));
            Platform.runLater(() -> this.getChildren().addAll((Object[])new Node[]{premiumTile, modulesPane}));
        }
    }
}

