/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.utils.MaterialDesignIconFactory;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javax.inject.Inject;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.ui.dashboard.DashboardItem;
import org.pdfsam.ui.dashboard.preference.PreferencePane;

@Auto
public class PreferencesDashboardItem
implements DashboardItem {
    public static final String PDFSAM_DISABLE_SETTINGS_DEPRECATED = "org.pdfsam.settings.panel";
    public static final String PDFSAM_DISABLE_SETTINGS = "org.pdfsam.disable.settings.panel";
    public static final String ID = "SETTINGS";
    private PreferencePane pane;

    @Inject
    PreferencesDashboardItem(PreferencePane pane) {
        this.pane = pane;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String name() {
        return DefaultI18nContext.getInstance().i18n("Settings");
    }

    @Override
    public Pane pane() {
        return this.pane;
    }

    @Override
    public Node graphic() {
        return MaterialDesignIconFactory.get().createIcon((GlyphIcons)MaterialDesignIcon.SETTINGS, "26.0");
    }

    @Override
    public int priority() {
        return -5;
    }

    @Override
    public boolean disabled() {
        return Boolean.getBoolean(PDFSAM_DISABLE_SETTINGS_DEPRECATED) || Boolean.getBoolean(PDFSAM_DISABLE_SETTINGS);
    }
}

