/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard;

import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.TextAlignment;
import org.pdfsam.eventstudio.Listener;
import org.pdfsam.eventstudio.ReferenceStrength;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.commons.SetActiveModuleRequest;
import org.pdfsam.ui.dashboard.DashboardItem;
import org.pdfsam.ui.support.Style;
import org.sejda.commons.util.RequireUtils;

class DashboardItemPane
extends BorderPane {
    private DashboardItem item;
    private Listener<SetActiveModuleRequest> enableFooterListener = e -> {
        this.unregister();
        this.setBottom((Node)this.buildFooter());
    };

    DashboardItemPane(DashboardItem item) {
        RequireUtils.requireNotNullArg((Object)item, (String)"Dashboard item cannot be null");
        this.item = item;
        this.item.pane().getStyleClass().addAll((Object[])Style.DEAULT_CONTAINER.css());
        this.item.pane().getStyleClass().addAll((Object[])Style.CONTAINER.css());
        ScrollPane scroll = new ScrollPane((Node)this.item.pane());
        scroll.getStyleClass().addAll((Object[])Style.DEAULT_CONTAINER.css());
        scroll.setFitToWidth(true);
        scroll.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.setCenter((Node)scroll);
        StaticStudio.eventStudio().add(SetActiveModuleRequest.class, this.enableFooterListener, Integer.MAX_VALUE, ReferenceStrength.STRONG);
    }

    private void unregister() {
        StaticStudio.eventStudio().remove(SetActiveModuleRequest.class, this.enableFooterListener);
    }

    private HBox buildFooter() {
        Button closeButton = new Button(DefaultI18nContext.getInstance().i18n("Close"));
        closeButton.getStyleClass().addAll((Object[])Style.BUTTON.css());
        closeButton.setTextAlignment(TextAlignment.CENTER);
        closeButton.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)SetActiveModuleRequest.activeteCurrentModule()));
        HBox footer = new HBox(new Node[]{closeButton});
        footer.getStyleClass().addAll((Object[])Style.CLOSE_FOOTER.css());
        return footer;
    }

    DashboardItem getItem() {
        return this.item;
    }
}

