/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.banner;

import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.animation.Timeline;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.news.HideNewsPanelRequest;
import org.pdfsam.news.ShowNewsPanelRequest;
import org.pdfsam.ui.banner.BannerButton;
import org.pdfsam.ui.commons.Animations;

class NewsButton
extends BannerButton {
    static final String UP_TO_DATE_CSS_CLASS = "news-not-up-to-date";
    private Timeline anim;
    private Object action = ShowNewsPanelRequest.INSTANCE;

    NewsButton() {
        super(MaterialDesignIcon.NEWSPAPER);
        this.setOnAction(e -> {
            StaticStudio.eventStudio().broadcast(this.action);
            this.action = this.switchAction();
        });
        this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("What's new")));
        this.anim = Animations.shake((Node)this);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    private Object switchAction() {
        if (this.action instanceof ShowNewsPanelRequest) {
            return HideNewsPanelRequest.INSTANCE;
        }
        return ShowNewsPanelRequest.INSTANCE;
    }

    public void setUpToDate(boolean value) {
        if (value) {
            this.getStyleClass().remove((Object)UP_TO_DATE_CSS_CLASS);
            this.anim.stop();
            this.setRotate(0.0);
            this.setScaleY(1.0);
        } else {
            this.getStyleClass().add((Object)UP_TO_DATE_CSS_CLASS);
            this.anim.play();
        }
    }

    @EventListener
    public void onShowNewsPanel(ShowNewsPanelRequest req) {
        this.setUpToDate(true);
    }
}

