/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.banner;

import javafx.application.Platform;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javax.inject.Inject;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.banner.ModulesMenu;
import org.pdfsam.ui.banner.WorkspaceMenu;
import org.pdfsam.ui.event.SetActiveDashboardItemRequest;

class AppContextMenu
extends ContextMenu {
    @Inject
    AppContextMenu(WorkspaceMenu workspace, ModulesMenu modulesMenu) {
        MenuItem exit = new MenuItem(DefaultI18nContext.getInstance().i18n("E_xit"));
        exit.setOnAction(e -> Platform.exit());
        exit.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Q, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        this.getItems().addAll((Object[])new MenuItem[]{workspace, modulesMenu});
        if (!Boolean.getBoolean("org.pdfsam.settings.panel") && !Boolean.getBoolean("org.pdfsam.disable.settings.panel")) {
            MenuItem settings = new MenuItem(DefaultI18nContext.getInstance().i18n("_Settings"));
            settings.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new SetActiveDashboardItemRequest("SETTINGS")));
            this.getItems().add((Object)settings);
        }
        this.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), exit});
    }
}

