/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.sound;

import javafx.scene.media.AudioClip;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.context.UserContext;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.injector.Auto;
import org.sejda.commons.util.RequireUtils;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;

@Auto
public class PlaySoundController {
    private UserContext userContext;
    private String okSoundURI;
    private String errorSoundURI;

    @Inject
    public PlaySoundController(UserContext userContext, @Named(value="okSound") String okSoundURI, @Named(value="errorSound") String errorSoundURI) {
        RequireUtils.requireNotBlank((String)okSoundURI, (String)"");
        RequireUtils.requireNotBlank((String)errorSoundURI, (String)"");
        this.userContext = userContext;
        this.okSoundURI = okSoundURI;
        this.errorSoundURI = errorSoundURI;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void playFailed(TaskExecutionFailedEvent event) {
        this.playSound(this.errorSoundURI);
    }

    @EventListener
    public void playCompleted(TaskExecutionCompletedEvent event) {
        this.playSound(this.okSoundURI);
    }

    private void playSound(String soundURI) {
        if (this.userContext.isPlaySounds()) {
            new AudioClip(soundURI).play(1.0);
        }
    }
}

