/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam;

import java.util.Optional;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.pdfsam.injector.Auto;
import org.pdfsam.ui.StageService;
import org.pdfsam.ui.StageStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
class WindowStatusController {
    private static final Logger LOG = LoggerFactory.getLogger(WindowStatusController.class);
    public static final String PDFSAM_DISABLE_UI_RESTORE = "org.pdfsam.disable.ui.restore";
    private Stage stage;
    private StageService service;

    @Inject
    WindowStatusController(StageService service) {
        this.service = service;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
        this.initUi();
    }

    private void initUi() {
        StageStatus latestStatus = this.service.getLatestStatus();
        if (!Boolean.getBoolean(PDFSAM_DISABLE_UI_RESTORE) && !StageStatus.NULL.equals((Object)latestStatus) && this.hasAvailableScreen(latestStatus)) {
            this.restore(latestStatus);
            LOG.trace("Stage status restored to {}", (Object)latestStatus);
        } else {
            this.defaultStageStatus();
            LOG.trace("Stage status set to default values");
        }
    }

    private void defaultStageStatus() {
        Rectangle2D primScreenBounds = Screen.getPrimary().getVisualBounds();
        this.stage.setX((primScreenBounds.getWidth() - this.stage.getWidth()) / 2.0);
        this.stage.setY((primScreenBounds.getHeight() - this.stage.getHeight()) / 4.0);
        this.stage.setMaximized(true);
    }

    private void restore(StageStatus latestStatus) {
        this.stage.setX(latestStatus.getX());
        this.stage.setY(latestStatus.getY());
        this.stage.setWidth(latestStatus.getWidth());
        this.stage.setHeight(latestStatus.getHeight());
        if (this.isNotMac()) {
            latestStatus.getMode().restore(this.stage);
        }
    }

    private boolean isNotMac() {
        return !Optional.of(System.getProperty("os.name")).orElse("").toLowerCase().contains("mac");
    }

    private boolean hasAvailableScreen(StageStatus status) {
        return !Screen.getScreensForRectangle((double)status.getX(), (double)status.getY(), (double)status.getWidth(), (double)status.getHeight()).isEmpty();
    }
}

