/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.util;

public final class StringUtils {
    private StringUtils() {
    }

    public static String asUnicodes(String in) {
        int codepoint;
        if (in == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int offset = 0; offset < in.length(); offset += Character.charCount(codepoint)) {
            codepoint = in.codePointAt(offset);
            result.append("\\U+").append(Integer.toHexString(codepoint).toUpperCase());
        }
        return result.toString();
    }

    public static String normalizeLineEndings(String in) {
        return in.replaceAll("\\r\\n", "\n");
    }

    public static String isolateRTLIfRequired(String s) {
        if (StringUtils.isRtl(s)) {
            return '\u2068' + s + '\u2069';
        }
        return s;
    }

    public static boolean isRtl(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            byte d = Character.getDirectionality(string.charAt(i));
            switch (d) {
                case 1: 
                case 2: 
                case 16: 
                case 17: {
                    return true;
                }
                case 0: 
                case 14: 
                case 15: {
                    return false;
                }
            }
        }
        return false;
    }
}

