/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix.processor;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.core.support.prefix.processor.AppendExtensionPrefixProcessor;
import org.sejda.core.support.prefix.processor.LoggingPrefixProcessorDecorator;
import org.sejda.core.support.prefix.processor.PrefixProcessor;
import org.sejda.core.support.prefix.processor.PrefixType;
import org.sejda.core.support.prefix.processor.PrefixUtils;
import org.sejda.core.support.prefix.processor.PrependPageNumberPrefixProcessor;
import org.sejda.core.support.prefix.processor.PrependPrefixProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixTypesChain {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixTypesChain.class);
    private Set<PrefixType> prefixesChanin = new HashSet<PrefixType>();
    private boolean ensureUniqueness = false;
    private PrefixProcessor prefixPrepend = new LoggingPrefixProcessorDecorator(new PrependPrefixProcessor());
    private PrefixProcessor pageNumberPrepend = new LoggingPrefixProcessorDecorator(new PrependPageNumberPrefixProcessor());
    private PrefixProcessor extensionProcessor = new LoggingPrefixProcessorDecorator(new AppendExtensionPrefixProcessor());

    public PrefixTypesChain(String prefix) {
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            for (PrefixType type : PrefixType.values()) {
                if (!type.isFoundIn(prefix)) continue;
                this.prefixesChanin.add(type);
                if (this.ensureUniqueness || !type.isEnsureUniqueNames()) continue;
                this.ensureUniqueness = true;
            }
        }
    }

    public String process(String prefix, NameGenerationRequest request) {
        LOG.trace("Performing prefix processing with first level prefix chain");
        String retVal = this.processChain(prefix, request, this.prefixesChanin);
        if (this.prefixesChanin.isEmpty()) {
            retVal = this.prefixPrepend.process(retVal, request);
        }
        if (!this.ensureUniqueness) {
            retVal = this.pageNumberPrepend.process(retVal, request);
        }
        return this.extensionProcessor.process(PrefixUtils.toSafeFilename(retVal), request);
    }

    private String processChain(String prefix, NameGenerationRequest request, Set<PrefixType> chain) {
        String retVal = prefix;
        for (PrefixType type : chain) {
            retVal = new LoggingPrefixProcessorDecorator(type.getProcessor()).process(retVal, request);
        }
        return retVal;
    }
}

