/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.notification.strategy;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.sejda.core.notification.strategy.NotificationStrategy;
import org.sejda.model.notification.EventListener;
import org.sejda.model.notification.event.AbstractNotificationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncNotificationStrategy
implements NotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncNotificationStrategy.class);
    private static final ThreadLocal<ExecutorService> THREAD_LOCAL = new ThreadLocal<ExecutorService>(){

        @Override
        protected ExecutorService initialValue() {
            return Executors.newSingleThreadExecutor();
        }
    };

    @Override
    public void notifyListener(EventListener listener, AbstractNotificationEvent event) {
        if (listener != null) {
            THREAD_LOCAL.get().execute(new NotifyRunnable(listener, event));
        }
    }

    private static final class NotifyRunnable
    implements Runnable {
        private final EventListener listener;
        private final AbstractNotificationEvent event;

        private NotifyRunnable(EventListener listener, AbstractNotificationEvent event) {
            this.listener = listener;
            this.event = event;
        }

        @Override
        public void run() {
            try {
                this.listener.onEvent(this.event);
            }
            catch (RuntimeException e) {
                LOG.error(String.format("An error occurred notifying event %s", this.event), (Throwable)e);
                throw e;
            }
        }
    }
}

