/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.printing;

import java.awt.RenderingHints;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.printing.Orientation;
import org.sejda.sambox.printing.PDFPrintable;
import org.sejda.sambox.printing.Scaling;

public final class PDFPageable
extends Book {
    private final PDDocument document;
    private final boolean showPageBorder;
    private final float dpi;
    private final Orientation orientation;
    private boolean subsamplingAllowed = false;
    private RenderingHints renderingHints = null;

    public PDFPageable(PDDocument document) {
        this(document, Orientation.AUTO, false, 0.0f);
    }

    public PDFPageable(PDDocument document, Orientation orientation) {
        this(document, orientation, false, 0.0f);
    }

    public PDFPageable(PDDocument document, Orientation orientation, boolean showPageBorder) {
        this(document, orientation, showPageBorder, 0.0f);
    }

    public PDFPageable(PDDocument document, Orientation orientation, boolean showPageBorder, float dpi) {
        this.document = document;
        this.orientation = orientation;
        this.showPageBorder = showPageBorder;
        this.dpi = dpi;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = renderingHints;
    }

    public boolean isSubsamplingAllowed() {
        return this.subsamplingAllowed;
    }

    public void setSubsamplingAllowed(boolean subsamplingAllowed) {
        this.subsamplingAllowed = subsamplingAllowed;
    }

    @Override
    public int getNumberOfPages() {
        return this.document.getNumberOfPages();
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) {
        boolean isLandscape;
        Paper paper;
        PDPage page = this.document.getPage(pageIndex);
        PDRectangle mediaBox = PDFPrintable.getRotatedMediaBox(page);
        PDRectangle cropBox = PDFPrintable.getRotatedCropBox(page);
        if (mediaBox.getWidth() > mediaBox.getHeight()) {
            paper = new Paper();
            paper.setSize(mediaBox.getHeight(), mediaBox.getWidth());
            paper.setImageableArea(cropBox.getLowerLeftY(), cropBox.getLowerLeftX(), cropBox.getHeight(), cropBox.getWidth());
            isLandscape = true;
        } else {
            paper = new Paper();
            paper.setSize(mediaBox.getWidth(), mediaBox.getHeight());
            paper.setImageableArea(cropBox.getLowerLeftX(), cropBox.getLowerLeftY(), cropBox.getWidth(), cropBox.getHeight());
            isLandscape = false;
        }
        PageFormat format = new PageFormat();
        format.setPaper(paper);
        if (this.orientation == Orientation.AUTO) {
            if (isLandscape) {
                format.setOrientation(0);
            } else {
                format.setOrientation(1);
            }
        } else if (this.orientation == Orientation.LANDSCAPE) {
            format.setOrientation(0);
        } else if (this.orientation == Orientation.PORTRAIT) {
            format.setOrientation(1);
        }
        return format;
    }

    @Override
    public Printable getPrintable(int i) {
        if (i >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException(i + " >= " + this.getNumberOfPages());
        }
        PDFPrintable printable = new PDFPrintable(this.document, Scaling.ACTUAL_SIZE, this.showPageBorder, this.dpi);
        printable.setSubsamplingAllowed(this.subsamplingAllowed);
        printable.setRenderingHints(this.renderingHints);
        return printable;
    }
}

