/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.util.Optional;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDCheckBox;
import org.sejda.sambox.pdmodel.interactive.form.PDComboBox;
import org.sejda.sambox.pdmodel.interactive.form.PDField;
import org.sejda.sambox.pdmodel.interactive.form.PDListBox;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDPushButton;
import org.sejda.sambox.pdmodel.interactive.form.PDRadioButton;
import org.sejda.sambox.pdmodel.interactive.form.PDSignatureField;
import org.sejda.sambox.pdmodel.interactive.form.PDTextField;

public final class PDFieldFactory {
    private static final String FIELD_TYPE_TEXT = "Tx";
    private static final String FIELD_TYPE_BUTTON = "Btn";
    private static final String FIELD_TYPE_CHOICE = "Ch";
    private static final String FIELD_TYPE_SIGNATURE = "Sig";

    private PDFieldFactory() {
    }

    public static PDField createFieldAddingChildToParent(PDAcroForm form, COSDictionary field, PDNonTerminalField parent) {
        PDField retField = PDFieldFactory.createField(form, field, parent);
        Optional.ofNullable(retField.getParent()).ifPresent(p -> p.addChild(retField));
        return retField;
    }

    public static PDField createField(PDAcroForm form, COSDictionary field, PDNonTerminalField parent) {
        String fieldType = PDFieldFactory.findFieldType(field);
        if (FIELD_TYPE_CHOICE.equals(fieldType)) {
            return PDFieldFactory.createChoiceSubType(form, field, parent);
        }
        if (FIELD_TYPE_TEXT.equals(fieldType)) {
            return new PDTextField(form, field, parent);
        }
        if (FIELD_TYPE_SIGNATURE.equals(fieldType)) {
            return new PDSignatureField(form, field, parent);
        }
        if (FIELD_TYPE_BUTTON.equals(fieldType)) {
            return PDFieldFactory.createButtonSubType(form, field, parent);
        }
        return new PDNonTerminalField(form, field, parent);
    }

    private static PDField createChoiceSubType(PDAcroForm form, COSDictionary field, PDNonTerminalField parent) {
        int flags = field.getInt(COSName.FF, 0);
        if ((flags & 0x20000) != 0) {
            return new PDComboBox(form, field, parent);
        }
        return new PDListBox(form, field, parent);
    }

    private static PDField createButtonSubType(PDAcroForm form, COSDictionary field, PDNonTerminalField parent) {
        int flags = field.getInt(COSName.FF, 0);
        if ((flags & 0x8000) != 0) {
            return new PDRadioButton(form, field, parent);
        }
        if ((flags & 0x10000) != 0) {
            return new PDPushButton(form, field, parent);
        }
        return new PDCheckBox(form, field, parent);
    }

    private static String findFieldType(COSDictionary dic) {
        COSDictionary parent;
        String retval = dic.getNameAsString(COSName.FT);
        if (retval == null && (parent = dic.getDictionaryObject(COSName.PARENT, COSName.P, COSDictionary.class)) != null) {
            retval = PDFieldFactory.findFieldType(parent);
        }
        return retval;
    }
}

