/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.input.ContentStreamParser;
import org.sejda.sambox.output.ContentStreamWriter;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.graphics.color.PDColor;
import org.sejda.sambox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.sejda.sambox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.sejda.sambox.pdmodel.interactive.form.AppearanceStyle;
import org.sejda.sambox.pdmodel.interactive.form.DefaultAppearanceHelper;
import org.sejda.sambox.pdmodel.interactive.form.PDDefaultAppearanceString;
import org.sejda.sambox.pdmodel.interactive.form.PDListBox;
import org.sejda.sambox.pdmodel.interactive.form.PDTextField;
import org.sejda.sambox.pdmodel.interactive.form.PDVariableText;
import org.sejda.sambox.pdmodel.interactive.form.PlainText;
import org.sejda.sambox.pdmodel.interactive.form.PlainTextFormatter;
import org.sejda.sambox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppearanceGeneratorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AppearanceGeneratorHelper.class);
    private static final Operator BMC = Operator.getOperator("BMC");
    private static final Operator EMC = Operator.getOperator("EMC");
    private final PDVariableText field;
    private PDDefaultAppearanceString defaultAppearance;
    private String value;
    private static final float[] HIGHLIGHT_COLOR = new float[]{0.6f, 0.75686276f, 0.84313726f};
    private static final int FONTSCALE = 1000;
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private static final float DEFAULT_PADDING = 0.5f;

    public AppearanceGeneratorHelper(PDVariableText field) throws IOException {
        this.field = field;
        this.validateAndEnsureAcroFormResources();
        try {
            this.defaultAppearance = field.getDefaultAppearanceString();
        }
        catch (IOException ex) {
            throw new IOException("Could not process default appearance string '" + field.getDefaultAppearance() + "' for field '" + field.getFullyQualifiedName() + "'", ex);
        }
    }

    private void validateAndEnsureAcroFormResources() {
        if (this.field.getAcroForm().getDefaultResources() == null) {
            return;
        }
        PDResources acroFormResources = this.field.getAcroForm().getDefaultResources();
        for (PDAnnotationWidget widget : this.field.getWidgets()) {
            if (widget.getNormalAppearanceStream() == null || widget.getNormalAppearanceStream().getResources() == null) continue;
            PDResources widgetResources = widget.getNormalAppearanceStream().getResources();
            HashMap<COSName, PDFont> missingFonts = new HashMap<COSName, PDFont>();
            for (COSName fontResourceName : widgetResources.getFontNames()) {
                try {
                    if (acroFormResources.getFont(fontResourceName) != null) continue;
                    LOG.debug("Adding font resource " + fontResourceName + " from widget to AcroForm");
                    missingFonts.put(fontResourceName, widgetResources.getFont(fontResourceName));
                }
                catch (IOException e) {
                    LOG.warn("Unable to match field level font with AcroForm font");
                }
            }
            for (COSName key : missingFonts.keySet()) {
                acroFormResources.put(key, (PDFont)missingFonts.get(key));
            }
        }
    }

    public void setAppearanceValue(String apValue) throws IOException {
        this.value = apValue;
        if (this.field instanceof PDTextField) {
            this.value = this.value.replaceAll("\\u00A0", " ");
        }
        if (this.field instanceof PDTextField && !((PDTextField)this.field).isMultiline()) {
            this.value = this.value.replaceAll("\\u000D\\u000A|[\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029]", " ");
        }
        for (PDAnnotationWidget widget : this.field.getWidgets()) {
            PDRectangle rect;
            PDDefaultAppearanceString acroFormAppearance = this.defaultAppearance;
            if (widget.getCOSObject().getDictionaryObject(COSName.DA) != null) {
                this.defaultAppearance = this.getWidgetDefaultAppearanceString(widget);
            }
            if ((rect = widget.getRectangle()) == null) {
                widget.getCOSObject().removeItem(COSName.AP);
                LOG.warn("widget of field {} has no rectangle, no appearance stream created", (Object)this.field.getFullyQualifiedName());
                continue;
            }
            PDFormFieldAdditionalActions actions = this.field.getActions();
            if (actions == null || actions.getF() == null || widget.getCOSObject().getDictionaryObject(COSName.AP) != null) {
                PDAppearanceStream appearanceStream;
                PDAppearanceEntry appearance;
                PDAppearanceDictionary appearanceDict = widget.getAppearance();
                if (appearanceDict == null) {
                    appearanceDict = new PDAppearanceDictionary();
                    widget.setAppearance(appearanceDict);
                }
                if (AppearanceGeneratorHelper.isValidAppearanceStream(appearance = appearanceDict.getNormalAppearance())) {
                    appearanceStream = appearance.getAppearanceStream();
                } else {
                    appearanceStream = this.prepareNormalAppearanceStream(widget);
                    appearanceDict.setNormalAppearance(appearanceStream);
                }
                if (widget.getAppearanceCharacteristics() != null || appearanceStream.getContentStream().getLength() == 0) {
                    this.initializeAppearanceContent(widget, appearanceStream);
                }
                this.setAppearanceContent(widget, appearanceStream);
            }
            this.defaultAppearance = acroFormAppearance;
        }
    }

    private static boolean isValidAppearanceStream(PDAppearanceEntry appearance) {
        if (Objects.isNull(appearance) || !appearance.isStream()) {
            return false;
        }
        PDRectangle bbox = appearance.getAppearanceStream().getBBox();
        if (bbox == null) {
            return false;
        }
        return Math.abs(bbox.getWidth()) > 0.0f && Math.abs(bbox.getHeight()) > 0.0f;
    }

    private PDAppearanceStream prepareNormalAppearanceStream(PDAnnotationWidget widget) {
        PDAppearanceStream appearanceStream = new PDAppearanceStream();
        int rotation = this.resolveRotation(widget);
        PDRectangle rect = widget.getRectangle();
        Matrix matrix = Matrix.getRotateInstance(Math.toRadians(rotation), 0.0f, 0.0f);
        Point2D.Float point2D = matrix.transformPoint(rect.getWidth(), rect.getHeight());
        PDRectangle bbox = new PDRectangle(Math.abs((float)point2D.getX()), Math.abs((float)point2D.getY()));
        appearanceStream.setBBox(bbox);
        AffineTransform at = this.calculateMatrix(bbox, rotation);
        if (!at.isIdentity()) {
            appearanceStream.setMatrix(at);
        }
        appearanceStream.setFormType(1);
        appearanceStream.setResources(new PDResources());
        return appearanceStream;
    }

    private PDDefaultAppearanceString getWidgetDefaultAppearanceString(PDAnnotationWidget widget) throws IOException {
        COSString da = DefaultAppearanceHelper.getDefaultAppearance(widget.getCOSObject().getDictionaryObject(COSName.DA));
        PDResources dr = this.field.getAcroForm().getDefaultResources();
        try {
            return new PDDefaultAppearanceString(da, dr);
        }
        catch (IOException ex) {
            LOG.warn("Failed to process default appearance string for widget {}, will use fallback default appearance", (Object)widget);
            return new PDDefaultAppearanceString();
        }
    }

    private int resolveRotation(PDAnnotationWidget widget) {
        PDAppearanceCharacteristicsDictionary characteristicsDictionary = widget.getAppearanceCharacteristics();
        if (characteristicsDictionary != null) {
            return characteristicsDictionary.getRotation();
        }
        return 0;
    }

    private void initializeAppearanceContent(PDAnnotationWidget widget, PDAppearanceStream appearanceStream) throws IOException {
        try (PDPageContentStream contents = new PDPageContentStream(this.field.getAcroForm().getDocument(), appearanceStream);){
            PDAppearanceCharacteristicsDictionary appearanceCharacteristics = widget.getAppearanceCharacteristics();
            if (appearanceCharacteristics != null) {
                PDBorderStyleDictionary borderStyle;
                PDColor backgroundColour = appearanceCharacteristics.getBackground();
                if (backgroundColour != null) {
                    contents.setNonStrokingColor(backgroundColour);
                    PDRectangle bbox = this.resolveBoundingBox(widget, appearanceStream);
                    contents.addRect(bbox.getLowerLeftX(), bbox.getLowerLeftY(), bbox.getWidth(), bbox.getHeight());
                    contents.fill();
                }
                float lineWidth = 0.0f;
                PDColor borderColour = appearanceCharacteristics.getBorderColour();
                if (borderColour != null) {
                    contents.setStrokingColor(borderColour);
                    lineWidth = 1.0f;
                }
                if ((borderStyle = widget.getBorderStyle()) != null && borderStyle.getWidth() > 0.0f) {
                    lineWidth = borderStyle.getWidth();
                }
                if (lineWidth > 0.0f && borderColour != null) {
                    if (lineWidth != 1.0f) {
                        contents.setLineWidth(lineWidth);
                    }
                    PDRectangle bbox = this.resolveBoundingBox(widget, appearanceStream);
                    PDRectangle clipRect = this.applyPadding(bbox, Math.max(0.5f, lineWidth / 2.0f));
                    contents.addRect(clipRect.getLowerLeftX(), clipRect.getLowerLeftY(), clipRect.getWidth(), clipRect.getHeight());
                    contents.closeAndStroke();
                }
            }
        }
    }

    private List<Object> tokenize(PDAppearanceStream appearanceStream) throws IOException {
        return new ContentStreamParser(appearanceStream).tokens();
    }

    private void setAppearanceContent(PDAnnotationWidget widget, PDAppearanceStream appearanceStream) throws IOException {
        this.defaultAppearance.copyNeededResourcesTo(appearanceStream);
        try (ContentStreamWriter writer = new ContentStreamWriter(CountingWritableByteChannel.from((OutputStream)appearanceStream.getCOSObject().createUnfilteredStream()));){
            List<Object> tokens = this.tokenize(appearanceStream);
            int bmcIndex = tokens.indexOf(BMC);
            if (bmcIndex == -1) {
                writer.writeTokens(tokens);
                writer.writeTokens(Arrays.asList(COSName.TX, BMC));
            } else {
                writer.writeTokens(tokens.subList(0, bmcIndex + 1));
            }
            this.insertGeneratedAppearance(widget, appearanceStream, writer);
            int emcIndex = tokens.indexOf(EMC);
            if (emcIndex == -1) {
                writer.writeTokens(EMC);
            } else {
                writer.writeTokens(tokens.subList(emcIndex, tokens.size()));
            }
        }
    }

    private void insertGeneratedAppearance(PDAnnotationWidget widget, PDAppearanceStream appearanceStream, ContentStreamWriter writer) throws IOException {
        float y;
        float newFontSize;
        float fontSize;
        boolean recalculateFontSize;
        PDPageContentStream contents = new PDPageContentStream(this.field.getAcroForm().getDocument(), appearanceStream, writer);
        PDRectangle bbox = this.resolveBoundingBox(widget, appearanceStream);
        float borderWidth = 0.0f;
        if (widget.getBorderStyle() != null) {
            borderWidth = widget.getBorderStyle().getWidth();
        }
        PDRectangle clipRect = this.applyPadding(bbox, Math.max(1.0f, borderWidth));
        PDRectangle contentRect = this.applyPadding(clipRect, Math.max(1.0f, borderWidth));
        contents.saveGraphicsState();
        contents.addRect(clipRect.getLowerLeftX(), clipRect.getLowerLeftY(), clipRect.getWidth(), clipRect.getHeight());
        contents.clip();
        PDFont font = Optional.ofNullable(this.field.getAppearanceFont()).orElseGet(() -> this.defaultAppearance.getFont());
        RequireUtils.requireNotNullArg((Object)font, (String)"font is null, check whether /DA entry is incomplete or incorrect");
        if (font.getName().contains("+")) {
            LOG.warn("Font '" + this.defaultAppearance.getFontName().getName() + "' of field '" + this.field.getFullyQualifiedName() + "' contains subsetted font '" + font.getName() + "'");
            LOG.warn("This may bring trouble with PDField.setValue(), PDAcroForm.flatten() or PDAcroForm.refreshAppearances()");
            LOG.warn("You should replace this font with a non-subsetted font:");
            LOG.warn("PDFont font = PDType0Font.load(doc, new FileInputStream(fontfile), false);");
            LOG.warn("acroForm.getDefaultResources().put(COSName.getPDFName(\"" + this.defaultAppearance.getFontName().getName() + "\", font);");
        }
        boolean bl = recalculateFontSize = (fontSize = this.defaultAppearance.getFontSize()) == 0.0f;
        if (this.field instanceof PDTextField && !((PDTextField)this.field).isMultiline()) {
            recalculateFontSize = true;
        }
        if (recalculateFontSize && ((newFontSize = this.calculateFontSize(font, contentRect)) < fontSize || fontSize == 0.0f)) {
            fontSize = newFontSize;
        }
        if (this.field instanceof PDListBox) {
            this.insertGeneratedListboxSelectionHighlight(contents, appearanceStream, font, fontSize);
        }
        contents.beginText();
        this.defaultAppearance.writeTo(contents, fontSize);
        float fontScaleY = fontSize / 1000.0f;
        float fontBoundingBoxAtSize = font.getBoundingBox().getHeight() * fontScaleY;
        float fontCapAtSize = font.getFontDescriptor().getCapHeight() * fontScaleY;
        float fontDescentAtSize = font.getFontDescriptor().getDescent() * fontScaleY;
        if (this.field instanceof PDTextField && ((PDTextField)this.field).isMultiline()) {
            y = contentRect.getUpperRightY() - this.calculateLineHeight(font, fontScaleY);
        } else if (fontCapAtSize > clipRect.getHeight()) {
            y = clipRect.getLowerLeftY() + -fontDescentAtSize;
        } else {
            y = clipRect.getLowerLeftY() + (clipRect.getHeight() - fontCapAtSize) / 2.0f;
            if ((y += 1.0f) - clipRect.getLowerLeftY() < -fontDescentAtSize) {
                float fontDescentBased = -fontDescentAtSize + contentRect.getLowerLeftY();
                float fontCapBased = contentRect.getHeight() - contentRect.getLowerLeftY() - fontCapAtSize;
                y = Math.min(fontDescentBased, Math.max(y, fontCapBased));
            }
        }
        float x = contentRect.getLowerLeftX();
        if (this.shallComb()) {
            this.insertGeneratedCombAppearance(contents, bbox, font, fontSize);
        } else if (this.field instanceof PDListBox) {
            this.insertGeneratedListboxAppearance(contents, appearanceStream, contentRect, font, fontSize);
        } else {
            PlainText textContent = new PlainText(this.value);
            AppearanceStyle appearanceStyle = new AppearanceStyle();
            appearanceStyle.setFont(font);
            appearanceStyle.setFontSize(fontSize);
            appearanceStyle.setLeading(this.calculateLineHeight(font, fontScaleY));
            PlainTextFormatter formatter = new PlainTextFormatter.Builder(contents).style(appearanceStyle).text(textContent).width(contentRect.getWidth()).wrapLines(this.isMultiLine()).initialOffset(x, y).textAlign(this.field.getQ()).build();
            formatter.format();
        }
        contents.endTextIfRequired();
        contents.restoreGraphicsState();
    }

    private AffineTransform calculateMatrix(PDRectangle bbox, int rotation) {
        if (rotation == 0) {
            return new AffineTransform();
        }
        float tx = 0.0f;
        float ty = 0.0f;
        switch (rotation) {
            case 90: {
                tx = bbox.getUpperRightY();
                break;
            }
            case 180: {
                tx = bbox.getUpperRightY();
                ty = bbox.getUpperRightX();
                break;
            }
            case 270: {
                ty = bbox.getUpperRightX();
                break;
            }
        }
        Matrix matrix = Matrix.getRotateInstance(Math.toRadians(rotation), tx, ty);
        return matrix.createAffineTransform();
    }

    private boolean isMultiLine() {
        return this.field instanceof PDTextField && ((PDTextField)this.field).isMultiline();
    }

    private boolean shallComb() {
        return this.field instanceof PDTextField && ((PDTextField)this.field).isComb() && !((PDTextField)this.field).isMultiline() && !((PDTextField)this.field).isPassword() && !((PDTextField)this.field).isFileSelect();
    }

    private void insertGeneratedCombAppearance(PDPageContentStream contents, PDRectangle bbox, PDFont font, float fontSize) throws IOException {
        int maxLen = ((PDTextField)this.field).getMaxLen();
        int numChars = Math.min(this.value.length(), maxLen);
        PDRectangle paddingEdge = this.applyPadding(bbox, 1.0f);
        float combWidth = bbox.getWidth() / (float)maxLen;
        float ascentAtFontSize = font.getFontDescriptor().getAscent() / 1000.0f * fontSize;
        float baselineOffset = paddingEdge.getLowerLeftY() + (bbox.getHeight() - ascentAtFontSize) / 2.0f;
        float prevCharWidth = 0.0f;
        float xOffset = combWidth / 2.0f;
        contents.saveGraphicsState();
        contents.setFont(font, fontSize);
        for (int i = 0; i < numChars; ++i) {
            String combString = this.value.substring(i, i + 1);
            float currCharWidth = font.getStringWidth(combString) / 1000.0f * fontSize / 2.0f;
            xOffset = xOffset + prevCharWidth / 2.0f - currCharWidth / 2.0f;
            contents.newLineAtOffset(xOffset, baselineOffset);
            contents.showText(combString);
            baselineOffset = 0.0f;
            prevCharWidth = currCharWidth;
            xOffset = combWidth;
        }
        contents.restoreGraphicsState();
    }

    private void insertGeneratedListboxSelectionHighlight(PDPageContentStream contents, PDAppearanceStream appearanceStream, PDFont font, float fontSize) throws IOException {
        List<Integer> indexEntries = ((PDListBox)this.field).getSelectedOptionsIndex();
        List<String> values = ((PDListBox)this.field).getValue();
        List<String> options = ((PDListBox)this.field).getOptionsExportValues();
        if (!values.isEmpty() && !options.isEmpty() && indexEntries.isEmpty()) {
            indexEntries = new ArrayList<Integer>();
            for (String v : values) {
                indexEntries.add(options.indexOf(v));
            }
        }
        int topIndex = ((PDListBox)this.field).getTopIndex();
        float highlightBoxHeight = font.getBoundingBox().getHeight() * fontSize / 1000.0f;
        PDRectangle paddingEdge = this.applyPadding(appearanceStream.getBBox(), 1.0f);
        for (int selectedIndex : indexEntries) {
            contents.setNonStrokingColor(HIGHLIGHT_COLOR[0], HIGHLIGHT_COLOR[1], HIGHLIGHT_COLOR[2]);
            contents.addRect(paddingEdge.getLowerLeftX(), paddingEdge.getUpperRightY() - highlightBoxHeight * (float)(selectedIndex - topIndex + 1) + 2.0f, paddingEdge.getWidth(), highlightBoxHeight);
            contents.fill();
        }
        contents.setNonStrokingColor(0.0);
    }

    private void insertGeneratedListboxAppearance(PDPageContentStream contents, PDAppearanceStream appearanceStream, PDRectangle contentRect, PDFont font, float fontSize) throws IOException {
        int topIndex;
        contents.setNonStrokingColor(0.0);
        int q = this.field.getQ();
        if (q == 1 || q == 2) {
            float fieldWidth = appearanceStream.getBBox().getWidth();
            float stringWidth = font.getStringWidth(this.value) / 1000.0f * fontSize;
            float adjustAmount = fieldWidth - stringWidth - 4.0f;
            if (q == 1) {
                adjustAmount /= 2.0f;
            }
            contents.newLineAtOffset(adjustAmount, 0.0f);
        } else if (q != 0) {
            throw new IOException("Error: Unknown justification value:" + q);
        }
        List<String> options = ((PDListBox)this.field).getOptionsDisplayValues();
        int numOptions = options.size();
        float yTextPos = contentRect.getUpperRightY();
        for (int i = topIndex = ((PDListBox)this.field).getTopIndex(); i < numOptions; ++i) {
            if (i == topIndex) {
                yTextPos -= font.getFontDescriptor().getAscent() / 1000.0f * fontSize;
            } else {
                yTextPos -= font.getBoundingBox().getHeight() / 1000.0f * fontSize;
                contents.beginText();
            }
            contents.newLineAtOffset(contentRect.getLowerLeftX(), yTextPos);
            contents.setFont(font, fontSize);
            contents.showText(this.replaceTabChars(options.get(i)));
            if (i == numOptions - 1) continue;
            contents.endText();
        }
    }

    private String replaceTabChars(String input) {
        return input.replace("\t", "    ");
    }

    private float calculateLineHeight(PDFont font, float fontScaleY) throws IOException {
        float fontDescentAtSize;
        float fontBoundingBoxAtSize = font.getBoundingBox().getHeight() * fontScaleY;
        float fontCapAtSize = font.getFontDescriptor().getCapHeight() * fontScaleY;
        float lineHeight = fontCapAtSize - (fontDescentAtSize = font.getFontDescriptor().getDescent() * fontScaleY);
        if (lineHeight < 0.0f) {
            lineHeight = fontBoundingBoxAtSize;
        }
        return lineHeight;
    }

    float calculateFontSize(PDFont font, PDRectangle contentRect) throws IOException {
        float yScalingFactor = 1000.0f * font.getFontMatrix().getScaleY();
        float xScalingFactor = 1000.0f * font.getFontMatrix().getScaleX();
        if (this.isMultiLine()) {
            boolean userTypedMultipleLines;
            float lineHeight = this.calculateLineHeight(font, font.getFontMatrix().getScaleY());
            float scaledContentHeight = contentRect.getHeight() * yScalingFactor;
            boolean looksLikeFauxMultiline = this.calculateLineHeight(font, 0.012f) > scaledContentHeight;
            int userTypedLinesCount = new PlainText(this.value).getParagraphs().size();
            boolean bl = userTypedMultipleLines = userTypedLinesCount > 1;
            if (looksLikeFauxMultiline && !userTypedMultipleLines) {
                LOG.warn("Faux multiline field found: {}", (Object)this.field.getFullyQualifiedName());
            } else {
                int minimumLinesToFitInAMultilineField = Math.max(2, userTypedLinesCount);
                float fontSize = scaledContentHeight / ((float)minimumLinesToFitInAMultilineField * lineHeight);
                return Math.min(fontSize, 12.0f);
            }
        }
        float width = font.getStringWidth(this.value) * font.getFontMatrix().getScaleX();
        float widthBasedFontSize = contentRect.getWidth() / width * xScalingFactor;
        float height = this.calculateLineHeight(font, font.getFontMatrix().getScaleY());
        float heightBasedFontSize = contentRect.getHeight() / height * yScalingFactor;
        return Math.min(heightBasedFontSize, widthBasedFontSize);
    }

    private PDRectangle resolveBoundingBox(PDAnnotationWidget fieldWidget, PDAppearanceStream appearanceStream) {
        PDRectangle boundingBox = appearanceStream.getBBox();
        if (boundingBox == null || this.hasZeroDimensions(boundingBox)) {
            boundingBox = fieldWidget.getRectangle().createRetranslatedRectangle();
        }
        return boundingBox;
    }

    private boolean hasZeroDimensions(PDRectangle bbox) {
        return bbox.getHeight() == 0.0f || bbox.getWidth() == 0.0f;
    }

    private PDRectangle applyPadding(PDRectangle box, float padding) {
        return new PDRectangle(box.getLowerLeftX() + padding, box.getLowerLeftY() + padding, box.getWidth() - 2.0f * padding, box.getHeight() - 2.0f * padding);
    }
}

