/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.documentnavigation.destination;

import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDDestination;

public abstract class PDPageDestination
extends PDDestination {
    protected COSArray array;

    protected PDPageDestination() {
        this.array = new COSArray();
    }

    protected PDPageDestination(COSArray arr) {
        this.array = arr;
    }

    public PDPage getPage() {
        COSBase page;
        PDPage retval = null;
        if (this.array.size() > 0 && (page = this.array.getObject(0)) instanceof COSDictionary) {
            retval = new PDPage((COSDictionary)page);
        }
        return retval;
    }

    public void setPage(PDPage page) {
        this.array.set(0, page);
    }

    public int getPageNumber() {
        COSBase page;
        int retval = -1;
        if (this.array.size() > 0 && (page = this.array.getObject(0)) instanceof COSNumber) {
            retval = ((COSNumber)page).intValue();
        }
        return retval;
    }

    public int retrievePageNumber() {
        int retval = -1;
        if (this.array.size() > 0) {
            COSBase page = this.array.getObject(0);
            if (page instanceof COSNumber) {
                retval = ((COSNumber)page).intValue();
            } else if (page instanceof COSDictionary) {
                return this.indexOfPageTree((COSDictionary)page);
            }
        }
        return retval;
    }

    private int indexOfPageTree(COSDictionary pageDict) {
        COSDictionary parent = pageDict;
        while (parent.getDictionaryObject(COSName.PARENT, COSName.P) instanceof COSDictionary) {
            parent = (COSDictionary)parent.getDictionaryObject(COSName.PARENT, COSName.P);
        }
        if (parent.containsKey(COSName.KIDS) && COSName.PAGES.equals(parent.getItem(COSName.TYPE))) {
            PDPageTree pages = new PDPageTree(parent);
            return pages.indexOf(new PDPage(pageDict));
        }
        return -1;
    }

    public void setPageNumber(int pageNumber) {
        this.array.set(0, COSInteger.get(pageNumber));
    }

    @Override
    public COSArray getCOSObject() {
        return this.array;
    }
}

