/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.graphics.color.PDColor;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceColorSpace;

public class PDDeviceCMYK
extends PDDeviceColorSpace {
    public static PDDeviceCMYK INSTANCE;
    private final PDColor initialColor = new PDColor(new float[]{0.0f, 0.0f, 0.0f, 1.0f}, (PDColorSpace)this);
    private final ICC_ColorSpace awtColorSpace;
    private boolean usePureJavaCMYKConversion = false;

    protected PDDeviceCMYK() throws IOException {
        ICC_Profile iccProfile = this.getICCProfile();
        if (iccProfile == null) {
            throw new IOException("Default CMYK color profile could not be loaded");
        }
        this.awtColorSpace = new ICC_ColorSpace(iccProfile);
        this.awtColorSpace.toRGB(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
        this.usePureJavaCMYKConversion = System.getProperty("org.sejda.sambox.rendering.UsePureJavaCMYKConversion") != null;
    }

    protected ICC_Profile getICCProfile() throws IOException {
        String name = "/org/sejda/sambox/resources/icc/ISOcoated_v2_300_bas.icc";
        try (InputStream is = PDDeviceCMYK.class.getResourceAsStream(name);){
            RequireUtils.requireIOCondition((boolean)Objects.nonNull(is), (String)("Error loading " + name));
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(is);
            return iCC_Profile;
        }
    }

    @Override
    public String getName() {
        return COSName.DEVICECMYK.getName();
    }

    @Override
    public int getNumberOfComponents() {
        return 4;
    }

    @Override
    public float[] getDefaultDecode(int bitsPerComponent) {
        return new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    @Override
    public PDColor getInitialColor() {
        return this.initialColor;
    }

    @Override
    public float[] toRGB(float[] value) {
        return this.awtColorSpace.toRGB(value);
    }

    @Override
    public BufferedImage toRGBImage(WritableRaster raster) {
        return this.toRGBImageAWT(raster, this.awtColorSpace);
    }

    @Override
    protected BufferedImage toRGBImageAWT(WritableRaster raster, ColorSpace colorSpace) {
        if (this.usePureJavaCMYKConversion) {
            BufferedImage dest = new BufferedImage(raster.getWidth(), raster.getHeight(), 1);
            ColorSpace destCS = dest.getColorModel().getColorSpace();
            WritableRaster destRaster = dest.getRaster();
            float[] srcValues = new float[4];
            float[] lastValues = new float[]{-1.0f, -1.0f, -1.0f, -1.0f};
            float[] destValues = new float[3];
            int width = raster.getWidth();
            int startX = raster.getMinX();
            int height = raster.getHeight();
            int startY = raster.getMinY();
            for (int x = startX; x < width + startX; ++x) {
                for (int y = startY; y < height + startY; ++y) {
                    raster.getPixel(x, y, srcValues);
                    if (!Arrays.equals(lastValues, srcValues)) {
                        int k;
                        for (k = 0; k < 4; ++k) {
                            lastValues[k] = srcValues[k];
                            srcValues[k] = srcValues[k] / 255.0f;
                        }
                        destValues = destCS.fromCIEXYZ(colorSpace.toCIEXYZ(srcValues));
                        for (k = 0; k < destValues.length; ++k) {
                            destValues[k] = destValues[k] * 255.0f;
                        }
                    }
                    destRaster.setPixel(x, y, destValues);
                }
            }
            return dest;
        }
        return super.toRGBImageAWT(raster, colorSpace);
    }

    static {
        try {
            INSTANCE = new PDDeviceCMYK();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

