/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.font;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.fontbox.cff.Type2CharString;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.util.BoundingBox;
import org.sejda.commons.util.ReflectionUtils;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.common.PDStream;
import org.sejda.sambox.pdmodel.font.CIDFontMapping;
import org.sejda.sambox.pdmodel.font.FontMappers;
import org.sejda.sambox.pdmodel.font.PDCIDFont;
import org.sejda.sambox.pdmodel.font.PDFontDescriptor;
import org.sejda.sambox.pdmodel.font.PDType0Font;
import org.sejda.sambox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDCIDFontType2
extends PDCIDFont {
    private static final Logger LOG = LoggerFactory.getLogger(PDCIDFontType2.class);
    private final TrueTypeFont ttf;
    private final int[] cid2gid;
    private final HashMap<Integer, Integer> gid2cid = new HashMap();
    private final boolean isEmbedded;
    private final boolean isDamaged;
    private boolean isOriginalEmbeddedMissing = false;
    private boolean isMappingFallbackUsed = false;
    private final CmapLookup cmap;
    private Matrix fontMatrix;
    private BoundingBox fontBBox;
    private final Set<Integer> noMapping = new HashSet<Integer>();
    private Map<String, Integer> invertedUnicodeCmap = null;

    public PDCIDFontType2(COSDictionary fontDictionary, PDType0Font parent) throws IOException {
        this(fontDictionary, parent, null);
    }

    public PDCIDFontType2(COSDictionary fontDictionary, PDType0Font parent, TrueTypeFont trueTypeFont) throws IOException {
        super(fontDictionary, parent);
        PDFontDescriptor fd = this.getFontDescriptor();
        if (trueTypeFont != null) {
            this.ttf = trueTypeFont;
            this.isEmbedded = true;
            this.isDamaged = false;
        } else {
            boolean fontIsDamaged = false;
            OpenTypeFont ttfFont = null;
            PDStream stream = null;
            if (fd != null) {
                stream = fd.getFontFile2();
                if (stream == null) {
                    stream = fd.getFontFile3();
                }
                if (stream == null) {
                    stream = fd.getFontFile();
                }
            }
            if (stream != null) {
                try {
                    OpenTypeFont otf;
                    OTFParser otfParser = new OTFParser(true);
                    ttfFont = otf = otfParser.parse(stream.createInputStream());
                    if (otf.isPostScript()) {
                        fontIsDamaged = true;
                        LOG.warn("Found CFF/OTF but expected embedded TTF font " + fd.getFontName());
                    }
                }
                catch (IOException | NullPointerException e) {
                    fontIsDamaged = true;
                    LOG.warn("Could not read embedded OTF for font " + this.getBaseFont(), (Throwable)e);
                }
            }
            this.isEmbedded = ttfFont != null;
            this.isDamaged = fontIsDamaged;
            if (ttfFont == null) {
                this.isOriginalEmbeddedMissing = true;
                ttfFont = this.findFontOrSubstitute();
            }
            this.ttf = ttfFont;
        }
        this.cmap = this.ttf.getUnicodeCmapLookup(false);
        this.cid2gid = this.readCIDToGIDMap();
        if (this.cid2gid != null) {
            for (int cid = 0; cid < this.cid2gid.length; ++cid) {
                int gid = this.cid2gid[cid];
                if (gid == 0) continue;
                this.gid2cid.put(gid, cid);
            }
        }
    }

    private TrueTypeFont findFontOrSubstitute() throws IOException {
        CIDFontMapping mapping = FontMappers.instance().getCIDFont(this.getBaseFont(), this.getFontDescriptor(), this.getCIDSystemInfo());
        TrueTypeFont ttfFont = mapping.isCIDFont() ? (TrueTypeFont)mapping.getFont() : (TrueTypeFont)mapping.getTrueTypeFont();
        if (mapping.isFallback()) {
            LOG.warn("Using fallback font " + ttfFont.getName() + " for CID-keyed TrueType font " + this.getBaseFont());
            this.isMappingFallbackUsed = true;
        }
        return ttfFont;
    }

    @Override
    public Matrix getFontMatrix() {
        if (this.fontMatrix == null) {
            this.fontMatrix = new Matrix(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
        }
        return this.fontMatrix;
    }

    @Override
    public BoundingBox getBoundingBox() throws IOException {
        if (this.fontBBox == null) {
            this.fontBBox = this.generateBoundingBox();
        }
        return this.fontBBox;
    }

    private BoundingBox generateBoundingBox() throws IOException {
        PDRectangle bbox;
        if (this.getFontDescriptor() != null && Objects.nonNull(bbox = this.getFontDescriptor().getFontBoundingBox()) && (Float.compare(bbox.getLowerLeftX(), 0.0f) != 0 || Float.compare(bbox.getLowerLeftY(), 0.0f) != 0 || Float.compare(bbox.getUpperRightX(), 0.0f) != 0 || Float.compare(bbox.getUpperRightY(), 0.0f) != 0)) {
            return new BoundingBox(bbox.getLowerLeftX(), bbox.getLowerLeftY(), bbox.getUpperRightX(), bbox.getUpperRightY());
        }
        return this.ttf.getFontBBox();
    }

    @Override
    public int codeToCID(int code) {
        CMap cMap = this.parent.getCMap();
        if (!cMap.hasCIDMappings() && cMap.hasUnicodeMappings()) {
            return cMap.toUnicode(code).codePointAt(0);
        }
        return cMap.toCID(code);
    }

    @Override
    public int codeToGID(int code) throws IOException {
        if (!this.isEmbedded) {
            if (this.cid2gid != null && !this.isDamaged) {
                LOG.warn("Using non-embedded GIDs in font " + this.getName());
                int cid = this.codeToCID(code);
                return this.cid2gid[cid];
            }
            String unicode = this.parent.toUnicode(code);
            if (unicode == null) {
                if (!this.noMapping.contains(code)) {
                    this.noMapping.add(code);
                    LOG.warn("Failed to find a character mapping for " + code + " in " + this.getName());
                }
                return this.codeToCID(code);
            }
            if (unicode.length() > 1) {
                LOG.warn("Trying to map multi-byte character using 'cmap', result will be poor");
            }
            return this.cmap.getGlyphId(unicode.codePointAt(0));
        }
        int cid = this.codeToCID(code);
        if (this.cid2gid != null) {
            if (cid < this.cid2gid.length) {
                return this.cid2gid[cid];
            }
            return 0;
        }
        if (cid < this.ttf.getNumberOfGlyphs()) {
            return cid;
        }
        return 0;
    }

    @Override
    public float getHeight(int code) throws IOException {
        return (this.ttf.getHorizontalHeader().getAscender() + -this.ttf.getHorizontalHeader().getDescender()) / this.ttf.getUnitsPerEm();
    }

    @Override
    public float getWidthFromFont(int code) throws IOException {
        int gid = this.codeToGID(code);
        int width = this.ttf.getAdvanceWidth(gid);
        int unitsPerEM = this.ttf.getUnitsPerEm();
        if (unitsPerEM != 1000) {
            width = (int)((float)width * (1000.0f / (float)unitsPerEM));
        }
        return width;
    }

    @Override
    public byte[] encode(int unicode) {
        int cid = -1;
        if (this.isEmbedded) {
            if (this.parent.getCMap().getName().startsWith("Identity-")) {
                int gid;
                if (this.cmap != null && (gid = this.cmap.getGlyphId(unicode)) != 0 && (cid = this.gid2cid.getOrDefault(gid, -1).intValue()) == -1) {
                    cid = gid;
                }
            } else if (this.parent.getCMapUCS2() != null) {
                cid = this.parent.getCMapUCS2().toCID(unicode);
            }
            if (cid == -1) {
                cid = this.lookupInInvertedUnicodeCmap(unicode);
            }
            if (cid == -1) {
                cid = 0;
            }
        } else {
            cid = this.cmap.getGlyphId(unicode);
        }
        if (cid == 0) {
            throw new IllegalArgumentException(String.format("No glyph for U+%04X (%c) in font %s", unicode, Character.valueOf((char)unicode), this.getName()));
        }
        return new byte[]{(byte)(cid >> 8 & 0xFF), (byte)(cid & 0xFF)};
    }

    private Map<String, Integer> generateInvertedUnicodeCmap() {
        CMap cMap = this.parent.getToUnicodeCMap();
        if (cMap != null) {
            Class<CMap> clazz = CMap.class;
            Field charToUnicodeField = ReflectionUtils.findField(clazz, (String)"charToUnicode");
            ReflectionUtils.makeAccessible((Field)charToUnicodeField);
            Map charToUnicode = (Map)ReflectionUtils.getField((Field)charToUnicodeField, (Object)cMap);
            if (charToUnicode != null) {
                HashMap<String, Integer> invertedUnicodeCmap = new HashMap<String, Integer>(charToUnicode.size());
                for (Integer code : charToUnicode.keySet()) {
                    invertedUnicodeCmap.put((String)charToUnicode.get(code), code);
                }
                return invertedUnicodeCmap;
            }
        }
        return new HashMap<String, Integer>();
    }

    private int lookupInInvertedUnicodeCmap(int unicode) {
        String s;
        if (this.invertedUnicodeCmap == null) {
            this.invertedUnicodeCmap = this.generateInvertedUnicodeCmap();
        }
        if (this.invertedUnicodeCmap.containsKey(s = new String(Character.toChars(unicode)))) {
            return this.invertedUnicodeCmap.get(s);
        }
        return -1;
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Override
    public boolean isDamaged() {
        return this.isDamaged;
    }

    public TrueTypeFont getTrueTypeFont() {
        return this.ttf;
    }

    @Override
    public GeneralPath getPath(int code) throws IOException {
        if (this.ttf instanceof OpenTypeFont && ((OpenTypeFont)this.ttf).isPostScript()) {
            int cid = this.codeToGID(code);
            Type2CharString charstring = ((OpenTypeFont)this.ttf).getCFF().getFont().getType2CharString(cid);
            return charstring.getPath();
        }
        int gid = this.codeToGID(code);
        GlyphData glyph = this.ttf.getGlyph().getGlyph(gid);
        if (glyph != null) {
            return glyph.getPath();
        }
        return new GeneralPath();
    }

    @Override
    public boolean hasGlyph(int code) throws IOException {
        return this.codeToGID(code) != 0;
    }

    @Override
    public boolean isOriginalEmbeddedMissing() {
        return this.isOriginalEmbeddedMissing;
    }

    @Override
    public boolean isMappingFallbackUsed() {
        return this.isMappingFallbackUsed;
    }
}

