/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.sejda.commons.util.IOUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSObjectKey;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.input.COSParser;
import org.sejda.sambox.input.ExistingIndirectCOSObject;
import org.sejda.sambox.input.IndirectObjectsProvider;
import org.sejda.sambox.input.ObjectsFullScanner;
import org.sejda.sambox.pdmodel.encryption.SecurityHandler;
import org.sejda.sambox.xref.CompressedXrefEntry;
import org.sejda.sambox.xref.Xref;
import org.sejda.sambox.xref.XrefEntry;
import org.sejda.sambox.xref.XrefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LazyIndirectObjectsProvider
implements IndirectObjectsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LazyIndirectObjectsProvider.class);
    private Xref xref = new Xref();
    private ObjectsFullScanner scanner;
    private Map<COSObjectKey, COSBase> store = new ConcurrentHashMap<COSObjectKey, COSBase>();
    private SecurityHandler securityHandler = null;
    private COSParser parser;

    LazyIndirectObjectsProvider() {
    }

    @Override
    public COSBase get(COSObjectKey key) {
        if (Objects.isNull(this.store.get(key))) {
            this.parseObject(key);
        }
        return this.store.get(key);
    }

    @Override
    public void release(COSObjectKey key) {
        this.store.remove(key);
    }

    @Override
    public XrefEntry addEntryIfAbsent(XrefEntry entry) {
        XrefEntry retVal = this.xref.addIfAbsent(entry);
        if (retVal == null) {
            LOG.trace("Added xref entry {}", (Object)entry);
        }
        return retVal;
    }

    @Override
    public XrefEntry addEntry(XrefEntry entry) {
        LOG.trace("Added xref entry {}", (Object)entry);
        return this.xref.add(entry);
    }

    @Override
    public COSObjectKey highestKey() {
        return this.xref.highestKey();
    }

    @Override
    public LazyIndirectObjectsProvider initializeWith(COSParser parser) {
        Objects.requireNonNull(parser);
        this.parser = parser;
        this.scanner = new ObjectsFullScanner(parser);
        return this;
    }

    @Override
    public LazyIndirectObjectsProvider initializeWith(SecurityHandler handler) {
        this.securityHandler = handler;
        return this;
    }

    private synchronized void parseObject(COSObjectKey key) {
        XrefEntry xrefEntry = this.xref.get(key);
        if (Objects.nonNull(xrefEntry)) {
            try {
                this.doParse(xrefEntry);
            }
            catch (IOException e) {
                LOG.warn("An error occurred while parsing " + xrefEntry, (Throwable)e);
                this.doParseFallbackObject(key);
            }
        } else {
            LOG.warn("Unable to find xref data for {}", (Object)key);
            this.doParseFallbackObject(key);
        }
    }

    private void doParseFallbackObject(COSObjectKey key) {
        LOG.info("Trying fallback strategy for " + key);
        XrefEntry xrefEntry = this.scanner.entries().get(key);
        if (Objects.nonNull(xrefEntry)) {
            try {
                this.doParse(xrefEntry);
            }
            catch (IOException e) {
                LOG.warn("Unable to find fallback xref entry for " + key, (Throwable)e);
            }
        } else {
            LOG.warn("Unable to find fallback xref entry for " + key);
        }
    }

    private void doParse(XrefEntry xrefEntry) throws IOException {
        LOG.trace("Parsing indirect object {}", (Object)xrefEntry);
        if (xrefEntry.getType() == XrefType.IN_USE) {
            this.parseInUseEntry(xrefEntry);
        }
        if (xrefEntry.getType() == XrefType.COMPRESSED) {
            this.parseCompressedEntry(xrefEntry);
        }
        LOG.trace("Parsing done");
    }

    private void parseInUseEntry(XrefEntry xrefEntry) throws IOException {
        this.parser.position(xrefEntry.getByteOffset());
        this.parser.skipExpectedIndirectObjectDefinition(xrefEntry.key());
        this.parser.skipSpaces();
        COSBase found = this.parser.nextParsedToken();
        this.parser.skipSpaces();
        if (this.parser.isNextToken("stream")) {
            RequireUtils.requireIOCondition((boolean)(found instanceof COSDictionary), (String)"Found stream with missing dictionary");
            found = this.parser.nextStream((COSDictionary)found);
            if (this.parser.skipTokenIfValue("endstream")) {
                LOG.warn("Found double 'endstream' token for {}", (Object)xrefEntry);
            }
        }
        if (this.securityHandler != null) {
            LOG.trace("Decrypting entry {}", (Object)xrefEntry);
            this.securityHandler.decrypt(found, xrefEntry.getObjectNumber(), xrefEntry.getGenerationNumber());
        }
        if (!this.parser.skipTokenIfValue("endobj")) {
            LOG.warn("Missing 'endobj' token for {}", (Object)xrefEntry);
        }
        if (found instanceof ExistingIndirectCOSObject) {
            ExistingIndirectCOSObject existingIndirectCOSObject = (ExistingIndirectCOSObject)found;
            if (existingIndirectCOSObject.id().objectIdentifier.equals(xrefEntry.key())) {
                LOG.warn("Found indirect object definition pointing to itself, for {}", (Object)xrefEntry);
                found = COSNull.NULL;
            }
        }
        this.store.put(xrefEntry.key(), Optional.ofNullable(found).orElse(COSNull.NULL));
    }

    private void parseCompressedEntry(XrefEntry xrefEntry) throws IOException {
        XrefEntry containingStreamEntry = this.xref.get(new COSObjectKey(((CompressedXrefEntry)xrefEntry).getObjectStreamNumber(), 0));
        RequireUtils.requireIOCondition((Objects.nonNull(containingStreamEntry) && containingStreamEntry.getType() != XrefType.COMPRESSED ? 1 : 0) != 0, (String)"Expected an uncompressed indirect object reference for the ObjectStream");
        this.parseObject(containingStreamEntry.key());
        COSBase stream = Optional.ofNullable(this.store.get(containingStreamEntry.key())).map(COSBase::getCOSObject).orElseThrow(() -> new IOException("Unable to find ObjectStream " + containingStreamEntry));
        if (!(stream instanceof COSStream)) {
            throw new IOException("Expected an object stream instance for " + containingStreamEntry);
        }
        this.parseObjectStream(containingStreamEntry, (COSStream)stream);
    }

    private void parseObjectStream(XrefEntry containingStreamEntry, COSStream stream) throws IOException {
        try (COSParser streamParser = new COSParser(stream.getUnfilteredSource(), this);){
            RequireUtils.requireIOCondition((!this.isIndirectContainedIn(stream.getItem(COSName.N), containingStreamEntry) ? 1 : 0) != 0, (String)"Objects stream size cannot be store as indirect reference in the ObjStm itself");
            int numberOfObjects = stream.getInt(COSName.N);
            RequireUtils.requireIOCondition((numberOfObjects >= 0 ? 1 : 0) != 0, (String)"Missing or negative required objects stream size");
            RequireUtils.requireIOCondition((!this.isIndirectContainedIn(stream.getItem(COSName.FIRST), containingStreamEntry) ? 1 : 0) != 0, (String)"Objects stream first offset cannot be store as indirect reference in the ObjStm itself");
            long firstOffset = stream.getLong(COSName.FIRST);
            RequireUtils.requireIOCondition((firstOffset >= 0L ? 1 : 0) != 0, (String)"Missing or negative required bytes offset of the fist object in the objects stream");
            TreeMap<Long, Long> entries = new TreeMap<Long, Long>();
            for (int i = 0; i < numberOfObjects; ++i) {
                long number = streamParser.readObjectNumber();
                long offset = firstOffset + streamParser.readLong();
                entries.put(offset, number);
            }
            LOG.trace("Found {} entries in object stream of size {}", (Object)entries.size(), (Object)streamParser.source().size());
            for (Map.Entry entry : entries.entrySet()) {
                COSObjectKey key;
                COSBase object;
                LOG.trace("Parsing compressed object {} at offset {}", entry.getValue(), entry.getKey());
                streamParser.position((Long)entry.getKey());
                if (streamParser.skipTokenIfValue("obj")) {
                    LOG.warn("Unexptected 'obj' token in objects stream");
                }
                if ((object = streamParser.nextParsedToken()) != null && containingStreamEntry.owns(this.xref.get(key = new COSObjectKey((Long)entry.getValue(), 0)))) {
                    LOG.trace("Parsed compressed object {} {}", (Object)key, object.getClass());
                    this.store.put(key, object);
                }
                if (!streamParser.skipTokenIfValue("endobj")) continue;
                LOG.warn("Unexptected 'endobj' token in objects stream");
            }
        }
        IOUtils.close((Closeable)stream);
    }

    private boolean isIndirectContainedIn(COSBase item, XrefEntry containingStreamEntry) {
        if (item instanceof ExistingIndirectCOSObject) {
            return Optional.ofNullable(item.id()).map(i -> i.objectIdentifier).map(this.xref::get).filter(e -> e instanceof CompressedXrefEntry).map(e -> (CompressedXrefEntry)e).map(e -> containingStreamEntry.key().objectNumber() == e.getObjectStreamNumber()).orElse(Boolean.FALSE);
        }
        return false;
    }

    @Override
    public void close() {
        this.store.values().stream().filter(o -> o instanceof Closeable).map(o -> (Closeable)((Object)o)).forEach(IOUtils::closeQuietly);
        this.store.clear();
    }

    @Override
    public String id() {
        return this.parser.source().id();
    }
}

