/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.encryption;

import java.util.Objects;
import java.util.Optional;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.encryption.Algorithm1;
import org.sejda.sambox.encryption.Algorithm1A;
import org.sejda.sambox.encryption.GeneralEncryptionAlgorithm;
import org.sejda.sambox.encryption.StandardSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncryptionContext {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionContext.class);
    public final StandardSecurity security;
    private byte[] documentId;
    private byte[] key;

    public EncryptionContext(StandardSecurity security) {
        RequireUtils.requireNotNullArg((Object)security, (String)"Cannot create an encryption context with a null security");
        this.security = security;
    }

    public void documentId(byte[] documentId) {
        this.documentId = documentId;
    }

    byte[] documentId() {
        return this.documentId;
    }

    void key(byte[] key) {
        this.key = key;
    }

    byte[] key() {
        return this.key;
    }

    public GeneralEncryptionAlgorithm encryptionAlgorithm() {
        return this.security.encryption.encryptionAlgorithm(this);
    }

    public static GeneralEncryptionAlgorithm encryptionAlgorithmFromEncryptionDictionary(COSDictionary enc, byte[] encryptionKey) {
        if (Objects.nonNull(enc)) {
            if (Objects.nonNull(encryptionKey)) {
                COSName filter = enc.getCOSName(COSName.FILTER);
                if (COSName.STANDARD.equals(filter)) {
                    int revision = enc.getInt(COSName.R);
                    switch (revision) {
                        case 2: 
                        case 3: {
                            return Algorithm1.withARC4Engine(encryptionKey);
                        }
                        case 4: {
                            COSName cryptFilterMethod = Optional.ofNullable(enc.getDictionaryObject(COSName.CF, COSDictionary.class)).map(d -> d.getDictionaryObject(COSName.STD_CF, COSDictionary.class)).map(d -> d.getCOSName(COSName.CFM)).orElse(COSName.NONE);
                            if (COSName.V2.equals(cryptFilterMethod)) {
                                return Algorithm1.withARC4Engine(encryptionKey);
                            }
                            if (COSName.AESV2.equals(cryptFilterMethod)) {
                                return Algorithm1.withAESEngine(encryptionKey);
                            }
                            LOG.warn("Unable to determine encryption algorithm");
                            return null;
                        }
                        case 5: 
                        case 6: {
                            return new Algorithm1A(encryptionKey);
                        }
                    }
                    LOG.warn("Unsupported or invalid standard security handler revision number {}", (Object)enc.getDictionaryObject(COSName.R));
                    return null;
                }
                LOG.warn("Unsupported encryption filter {}", (Object)filter);
            } else {
                LOG.warn("Empty encryption key");
            }
        }
        return null;
    }
}

