/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSObjectKey;

public final class IndirectCOSObjectIdentifier {
    public final COSObjectKey objectIdentifier;
    public final String ownerIdentifier;

    public IndirectCOSObjectIdentifier(COSObjectKey objectIdentifier, String ownerIdentifier) {
        RequireUtils.requireNotNullArg((Object)objectIdentifier, (String)"Object identifier cannot be null");
        RequireUtils.requireNotBlank((String)ownerIdentifier, (String)"Owning document identifier cannot be blank");
        this.objectIdentifier = objectIdentifier;
        this.ownerIdentifier = ownerIdentifier;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndirectCOSObjectIdentifier)) {
            return false;
        }
        IndirectCOSObjectIdentifier other = (IndirectCOSObjectIdentifier)obj;
        return this.objectIdentifier.equals(other.objectIdentifier) && this.ownerIdentifier.equals(other.ownerIdentifier);
    }

    public int hashCode() {
        return Long.hashCode((long)this.objectIdentifier.hashCode() + (long)this.ownerIdentifier.hashCode());
    }

    public String toString() {
        return this.objectIdentifier + " " + this.ownerIdentifier;
    }
}

