/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.contentstream.operator.graphics;

import java.io.IOException;
import java.util.List;
import org.sejda.sambox.contentstream.operator.MissingOperandException;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.contentstream.operator.graphics.GraphicsOperatorProcessor;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.MissingResourceException;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDTransparencyGroup;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DrawObject
extends GraphicsOperatorProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DrawObject.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Operator operator, List<COSBase> operands) throws IOException {
        if (operands.isEmpty()) {
            throw new MissingOperandException(operator, operands);
        }
        COSBase base0 = operands.get(0);
        if (!(base0 instanceof COSName)) {
            return;
        }
        COSName objectName = (COSName)base0;
        PDXObject xobject = this.getContext().getResources().getXObject(objectName);
        if (xobject == null) {
            throw new MissingResourceException("Missing XObject: " + objectName.getName());
        }
        if (xobject instanceof PDImageXObject) {
            PDImageXObject image = (PDImageXObject)xobject;
            this.getContext().drawImage(image);
        } else if (xobject instanceof PDFormXObject) {
            try {
                this.getContext().increaseLevel();
                if (this.getContext().getLevel() > 25) {
                    LOG.error("recursion is too deep, skipping form XObject");
                    return;
                }
                PDFormXObject form = (PDFormXObject)xobject;
                if (form instanceof PDTransparencyGroup) {
                    this.getContext().showTransparencyGroup((PDTransparencyGroup)form);
                } else {
                    this.getContext().showForm(form);
                }
            }
            finally {
                this.getContext().decreaseLevel();
            }
        }
    }

    @Override
    public String getName() {
        return "Do";
    }
}

