/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sejda.commons.util.IOUtils;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSourceSupplier;

public class ThreadBoundCopiesSupplier<T extends SeekableSource>
implements Closeable,
SeekableSourceSupplier<T> {
    private ConcurrentMap<Long, T> copies = new ConcurrentHashMap<Long, T>();
    private final SeekableSourceSupplier<T> supplier;

    public ThreadBoundCopiesSupplier(SeekableSourceSupplier<T> supplier) {
        Objects.requireNonNull(supplier);
        this.supplier = supplier;
    }

    @Override
    public T get() throws IOException {
        long id = Thread.currentThread().getId();
        SeekableSource copy = (SeekableSource)this.copies.get(id);
        if (Objects.isNull(copy)) {
            T newCopy = this.supplier.get();
            copy = (SeekableSource)this.copies.putIfAbsent(id, newCopy);
            if (Objects.isNull(copy)) {
                copy = newCopy;
            } else {
                IOUtils.closeQuietly(newCopy);
            }
        }
        return (T)copy;
    }

    @Override
    public void close() {
        this.copies.values().stream().forEach(IOUtils::closeQuietly);
    }
}

