/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import org.sejda.commons.util.IOUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.CountingWritableByteChannel;

public class BufferedCountingChannelWriter
implements Closeable {
    public static final String OUTPUT_BUFFER_SIZE_PROPERTY = "org.sejda.io.buffered.output.size";
    private static final byte EOL = 10;
    private CountingWritableByteChannel channel;
    private ByteBuffer buffer = ByteBuffer.allocate(Integer.getInteger("org.sejda.io.buffered.output.size", 4096));
    private boolean onNewLine = false;

    public BufferedCountingChannelWriter(CountingWritableByteChannel channel) {
        RequireUtils.requireNotNullArg((Object)channel, (String)"Cannot write to a null channell");
        this.channel = channel;
    }

    @Override
    public void close() throws IOException {
        if (this.channel.isOpen() && this.buffer.position() != 0) {
            this.flush();
        }
        IOUtils.close((Closeable)this.channel);
    }

    public void writeEOL() throws IOException {
        if (!this.onNewLine) {
            this.write((byte)10);
            this.onNewLine = true;
        }
    }

    public void write(String value) throws IOException {
        this.write(value.getBytes(StandardCharsets.ISO_8859_1));
    }

    public void write(byte[] bytes) throws IOException {
        for (int i = 0; i < bytes.length; ++i) {
            this.write(bytes[i]);
        }
    }

    public void write(byte myByte) throws IOException {
        this.onNewLine = false;
        this.buffer.put(myByte);
        if (!this.buffer.hasRemaining()) {
            this.flush();
        }
    }

    public void write(InputStream stream) throws IOException {
        this.onNewLine = false;
        try (ReadableByteChannel readable = Channels.newChannel(stream);){
            this.flush();
            while (readable.read(this.buffer) != -1) {
                this.flush();
            }
        }
    }

    public long offset() {
        return this.channel.count() + (long)this.buffer.position();
    }

    public void flush() throws IOException {
        this.buffer.flip();
        this.channel.write(this.buffer);
        this.buffer.clear();
    }
}

