/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.optimization;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sejda.commons.util.RequireUtils;
import org.sejda.impl.sambox.component.ContentStreamProcessor;
import org.sejda.impl.sambox.component.ReadOnlyFilteredCOSStream;
import org.sejda.impl.sambox.component.optimization.InUseDictionary;
import org.sejda.sambox.contentstream.PDContentStream;
import org.sejda.sambox.contentstream.operator.MissingOperandException;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.contentstream.operator.OperatorProcessor;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.IndirectCOSObjectIdentifier;
import org.sejda.sambox.pdmodel.MissingResourceException;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.font.PDType3CharProc;
import org.sejda.sambox.pdmodel.font.PDType3Font;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDTransparencyGroup;
import org.sejda.sambox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesHitter
extends ContentStreamProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesHitter.class);

    public ResourcesHitter() {
        this.addOperator(new XObjectHitterOperator());
        this.addOperator(new FontsHitterOperator());
        this.addOperator(new SetGraphicState());
    }

    public static class SetGraphicState
    extends OperatorProcessor {
        private final Map<IndirectCOSObjectIdentifier, InUseDictionary> hitGSById = new HashMap<IndirectCOSObjectIdentifier, InUseDictionary>();

        public void process(Operator operator, List<COSBase> operands) throws IOException {
            RequireUtils.require((!operands.isEmpty() ? 1 : 0) != 0, () -> new MissingOperandException(operator, operands));
            COSBase operand = operands.get(0);
            if (operand instanceof COSName) {
                COSName gsName = (COSName)operand;
                Optional<COSDictionary> states = Optional.ofNullable(this.getContext().getResources()).map(r -> (COSDictionary)r.getCOSObject().getDictionaryObject(COSName.EXT_G_STATE, COSDictionary.class));
                COSDictionary gsDictionary = states.map(d -> (COSDictionary)d.getDictionaryObject(gsName, COSDictionary.class)).orElseGet(() -> {
                    LOG.warn("Graphic state resource '{}' missing or unexpected type", (Object)gsName.getName());
                    return null;
                });
                if (Objects.nonNull(gsDictionary)) {
                    new PDExtendedGraphicsState(gsDictionary).copyIntoGraphicsState(this.getContext().getGraphicsState());
                    if (!(gsDictionary instanceof InUseDictionary)) {
                        if (gsDictionary.hasId()) {
                            LOG.trace("Hit ExtGState with name {} id {}", (Object)gsName.getName(), (Object)gsDictionary.id());
                            states.get().setItem(gsName, (COSBase)Optional.ofNullable(this.hitGSById.get(gsDictionary.id())).orElseGet(() -> {
                                InUseDictionary gs = new InUseDictionary(gsDictionary);
                                this.hitGSById.put(gsDictionary.id(), gs);
                                return gs;
                            }));
                        } else {
                            LOG.trace("Hit ExtGState with name {}", (Object)gsName.getName());
                            states.get().setItem(gsName, (COSBase)new InUseDictionary(gsDictionary));
                        }
                        Optional<COSStream> softMask = Optional.ofNullable(gsDictionary.getDictionaryObject(COSName.SMASK, COSDictionary.class)).map(d -> (COSStream)d.getDictionaryObject(COSName.G, COSStream.class)).filter(s -> COSName.FORM.getName().equals(s.getNameAsString(COSName.SUBTYPE)));
                        if (softMask.isPresent()) {
                            PDXObject xobject = PDXObject.createXObject((COSBase)((COSBase)softMask.get()), (PDResources)this.getContext().getResources());
                            if (xobject instanceof PDTransparencyGroup) {
                                this.getContext().showTransparencyGroup((PDTransparencyGroup)xobject);
                            } else if (xobject instanceof PDFormXObject) {
                                this.getContext().showForm((PDFormXObject)xobject);
                            }
                        }
                    }
                }
            }
        }

        public String getName() {
            return "gs";
        }
    }

    public static class FontsHitterOperator
    extends OperatorProcessor {
        private final Map<IndirectCOSObjectIdentifier, InUseDictionary> hitFontsById = new HashMap<IndirectCOSObjectIdentifier, InUseDictionary>();

        public void process(Operator operator, List<COSBase> operands) throws IOException {
            if (operands.size() < 2) {
                throw new MissingOperandException(operator, operands);
            }
            COSBase operand = operands.get(0);
            if (operand instanceof COSName) {
                COSName fontName = (COSName)operand;
                Optional<COSDictionary> fonts = Optional.ofNullable(this.getContext().getResources()).map(r -> (COSDictionary)r.getCOSObject().getDictionaryObject(COSName.FONT, COSDictionary.class));
                COSDictionary fontDictionary = fonts.map(d -> (COSDictionary)d.getDictionaryObject(fontName, COSDictionary.class)).orElseThrow(() -> new MissingResourceException("Font resource '" + fontName.getName() + "' missing or unexpected type"));
                if (!(fontDictionary instanceof InUseDictionary)) {
                    if (fontDictionary.hasId()) {
                        LOG.trace("Hit font with name {} id {}", (Object)fontName.getName(), (Object)fontDictionary.id());
                        fonts.get().setItem(fontName, (COSBase)Optional.ofNullable(this.hitFontsById.get(fontDictionary.id())).orElseGet(() -> {
                            InUseDictionary font = new InUseDictionary(fontDictionary);
                            this.hitFontsById.put(fontDictionary.id(), font);
                            return font;
                        }));
                    } else {
                        LOG.trace("Hit font with name {}", (Object)fontName.getName());
                        fonts.get().setItem(fontName, (COSBase)new InUseDictionary(fontDictionary));
                    }
                    if (COSName.TYPE3.equals((Object)fontDictionary.getCOSName(COSName.SUBTYPE))) {
                        PDType3Font font = new PDType3Font(fontDictionary);
                        Collection glyphStreams = Optional.ofNullable(fontDictionary.getDictionaryObject(COSName.CHAR_PROCS, COSDictionary.class)).map(chars -> chars.getValues()).filter(v -> !v.isEmpty()).orElseGet(Collections::emptyList);
                        List pdStreams = glyphStreams.stream().map(COSBase::getCOSObject).filter(s -> s instanceof COSStream).map(s -> (COSStream)s).map(s -> new PDType3CharProc(font, s)).collect(Collectors.toList());
                        LOG.trace("Found type3 font {} with {} streams to parse", (Object)fontName.getName(), (Object)pdStreams.size());
                        for (PDType3CharProc glyph : pdStreams) {
                            this.getContext().processStream((PDContentStream)glyph);
                        }
                    }
                }
            }
        }

        public String getName() {
            return "Tf";
        }
    }

    public static class XObjectHitterOperator
    extends OperatorProcessor {
        public void process(Operator operator, List<COSBase> operands) throws IOException {
            if (operands.isEmpty()) {
                throw new MissingOperandException(operator, operands);
            }
            COSBase operand = operands.get(0);
            if (operand instanceof COSName) {
                COSName objectName = (COSName)operand;
                Optional<COSDictionary> xobjects = Optional.ofNullable(this.getContext().getResources()).map(r -> (COSDictionary)r.getCOSObject().getDictionaryObject(COSName.XOBJECT, COSDictionary.class));
                COSBase existing = xobjects.map(d -> d.getDictionaryObject(objectName)).orElseThrow(() -> new MissingResourceException("Missing XObject: " + objectName.getName()));
                if (existing instanceof COSStream) {
                    if (!(existing instanceof ReadOnlyFilteredCOSStream)) {
                        COSStream imageStream = (COSStream)existing;
                        LOG.trace("Hit image with name {}", (Object)objectName.getName());
                        xobjects.get().setItem(objectName, (COSBase)ReadOnlyFilteredCOSStream.readOnly(imageStream));
                        if (COSName.FORM.getName().equals(imageStream.getNameAsString(COSName.SUBTYPE))) {
                            PDXObject xobject = PDXObject.createXObject((COSBase)imageStream, (PDResources)this.getContext().getResources());
                            if (xobject instanceof PDTransparencyGroup) {
                                this.getContext().showTransparencyGroup((PDTransparencyGroup)xobject);
                            } else if (xobject instanceof PDFormXObject) {
                                this.getContext().showForm((PDFormXObject)xobject);
                            }
                        }
                    }
                } else {
                    LOG.warn("Unexpected type {} for xObject {}", existing.getClass(), (Object)objectName.getName());
                }
            }
        }

        public String getName() {
            return "Do";
        }
    }
}

